/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jws.verifier;

import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.jws.verifier.VerifySignature;

public class VerifyRsaSignature
extends VerifySignature {
    private Signature signature;
    private Base64.Decoder decoder;

    public VerifyRsaSignature(Signature signature, Base64.Decoder decoder) {
        this.signature = signature;
        this.decoder = decoder;
    }

    @Override
    public boolean run(JsonWebToken token) {
        boolean isVerified = false;
        byte[] signInput = this.createSignInput(token.getJwt().get());
        try {
            this.signature.update(signInput);
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        byte[] decodedSignature = this.decoder.decode(token.getSignature().get());
        try {
            isVerified = this.signature.verify(decodedSignature);
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return isVerified;
    }
}

