/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serialization;

import java.util.Base64;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.exception.InvalidJWT;
import org.rootservices.jwt.serialization.Serdes;
import org.rootservices.jwt.serialization.exception.JsonException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public class HeaderDeserializer {
    public static final String JWT_SPLITTER = "\\.";
    public static final String INVALID_HEADER = "JOSE Header is invalid";
    public static final String JWT_IS_NOT_SPLITTABLE = "JWT is not splittable by '.'";
    private Base64.Decoder decoder;
    private Serdes serdes;

    public HeaderDeserializer(Base64.Decoder decoder, Serdes serdes) {
        this.decoder = decoder;
        this.serdes = serdes;
    }

    public Header toHeader(String encodedJwt) throws JsonToJwtException, InvalidJWT {
        Header header;
        String[] jwtParts = encodedJwt.split(JWT_SPLITTER);
        if (jwtParts.length == 0) {
            throw new InvalidJWT(JWT_IS_NOT_SPLITTABLE);
        }
        byte[] headerJson = this.decoder.decode(jwtParts[0]);
        try {
            header = (Header)this.serdes.jsonBytesToObject(headerJson, Header.class);
        }
        catch (JsonException e) {
            throw new JsonToJwtException(INVALID_HEADER, e);
        }
        return header;
    }
}

