/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.exception.InvalidJWT;
import org.rootservices.jwt.serialization.Serdes;
import org.rootservices.jwt.serialization.exception.JsonException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;
import org.rootservices.jwt.serialization.exception.JwtToJsonException;

public class JwtSerde {
    public static final String JWT_SPLITTER = "\\.";
    public static final String INVALID_JSON = "JWT json is invalid";
    public static final String COULD_NOT_SERIALIZE = "Could not make sign input";
    public static final String THIS_IS_A_JWE = "This is a JWE";
    public static final String TOO_MANY_MEMBERS = "Too many members";
    public static final String COULD_NOT_COMBINE_JWT_MEMBERS = "Could not combine jwt members";
    public static final String COULD_NOT_COMBINE_SIGN_INPUTS = "Could not combine sign inputs";
    public final int JWT_LENGTH = 2;
    public final int JWS_LENGTH = 3;
    public final int JWE_LENGTH = 5;
    private Serdes serdes;
    private Base64.Encoder encoder;
    private Base64.Decoder decoder;
    private final String DELIMITTER = ".";
    private final byte[] DELIMITER = ".".getBytes();

    public JwtSerde(Serdes serdes, Base64.Encoder encoder, Base64.Decoder decoder) {
        this.serdes = serdes;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public byte[] makeSignInput(Header header, Claims claims) throws JwtToJsonException {
        byte[] signInput;
        List<byte[]> members = this.membersForSigning(header, claims);
        try {
            signInput = this.compact(members, true).toByteArray();
        }
        catch (IOException e) {
            throw new JwtToJsonException(COULD_NOT_COMBINE_SIGN_INPUTS, e);
        }
        return signInput;
    }

    protected List<byte[]> membersForSigning(Header header, Claims claims) throws JwtToJsonException {
        byte[] claimsJson;
        byte[] headerJson;
        ArrayList<byte[]> members = new ArrayList<byte[]>();
        try {
            headerJson = this.serdes.objectToByte(header);
            claimsJson = this.serdes.objectToByte(claims);
        }
        catch (JsonException e) {
            throw new JwtToJsonException(COULD_NOT_SERIALIZE, e);
        }
        members.add(this.encoder.encode(headerJson));
        members.add(this.encoder.encode(claimsJson));
        return members;
    }

    public ByteArrayOutputStream compactJwt(JsonWebToken jwt) throws JwtToJsonException {
        ByteArrayOutputStream compactJwt;
        List<byte[]> members = this.membersForSigning(jwt.getHeader(), jwt.getClaims());
        if (jwt.getSignature().isPresent()) {
            members.add(jwt.getSignature().get());
        }
        try {
            compactJwt = this.compact(members, false);
        }
        catch (IOException e) {
            throw new JwtToJsonException(COULD_NOT_COMBINE_JWT_MEMBERS, e);
        }
        return compactJwt;
    }

    public JsonWebToken stringToJwt(String jwtAsText, Class claimClass) throws JsonToJwtException, InvalidJWT {
        JsonWebToken jwt;
        String[] jwtParts = jwtAsText.split(JWT_SPLITTER);
        if (jwtParts.length == 2) {
            jwt = this.jwt(jwtParts, claimClass, jwtAsText);
        } else if (jwtParts.length == 3 && jwtParts[2] != null) {
            jwt = this.jws(jwtParts, claimClass, jwtAsText);
        } else {
            if (jwtParts.length == 5) {
                throw new InvalidJWT(THIS_IS_A_JWE);
            }
            throw new InvalidJWT(TOO_MANY_MEMBERS);
        }
        return jwt;
    }

    protected JsonWebToken jwt(String[] jwtParts, Class claimClass, String jwtAsText) throws JsonToJwtException {
        Claims claim;
        Header header;
        byte[] headerJson = this.decoder.decode(jwtParts[0]);
        byte[] claimsJson = this.decoder.decode(jwtParts[1]);
        try {
            header = (Header)this.serdes.jsonBytesToObject(headerJson, Header.class);
            claim = (Claims)this.serdes.jsonBytesToObject(claimsJson, claimClass);
        }
        catch (JsonException e) {
            throw new JsonToJwtException(INVALID_JSON, e);
        }
        JsonWebToken jwt = new JsonWebToken(header, claim, Optional.of(jwtAsText));
        return jwt;
    }

    protected JsonWebToken jws(String[] jwsParts, Class claimClass, String jwtAsText) throws JsonToJwtException {
        JsonWebToken jwt = this.jwt(jwsParts, claimClass, jwtAsText);
        jwt.setSignature(Optional.of(jwsParts[2].getBytes()));
        return jwt;
    }

    protected ByteArrayOutputStream compact(List<byte[]> members, Boolean forSigning) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < members.size(); ++i) {
            if (members.get(i) != null) {
                outputStream.write(members.get(i));
            }
            if (!this.shouldAppendDelimiter(i, members.size(), forSigning).booleanValue()) continue;
            outputStream.write(this.DELIMITER);
            continue;
        }
        return outputStream;
    }

    protected Boolean shouldAppendDelimiter(int i, int numberOfMembers, Boolean forSigning) {
        return i < numberOfMembers - 1 || forSigning == false && i == numberOfMembers - 1 && i == 1;
    }
}

