/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.gateway.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.otter.controller.builder.ResponseBuilder;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.gateway.Gateway;
import org.rootservices.otter.gateway.servlet.GatewayResponse;
import org.rootservices.otter.gateway.servlet.merger.HttpServletRequestMerger;
import org.rootservices.otter.gateway.servlet.merger.HttpServletResponseMerger;
import org.rootservices.otter.gateway.servlet.translator.HttpServletRequestTranslator;
import org.rootservices.otter.router.Engine;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.exception.HaltException;
import org.rootservices.otter.security.session.between.EncryptSession;

public class ServletGateway
extends Gateway {
    protected static Logger logger = LogManager.getLogger(ServletGateway.class);
    private HttpServletRequestTranslator httpServletRequestTranslator;
    private HttpServletRequestMerger httpServletRequestMerger;
    private HttpServletResponseMerger httpServletResponseMerger;

    public ServletGateway(HttpServletRequestTranslator httpServletRequestTranslator, HttpServletRequestMerger httpServletRequestMerger, HttpServletResponseMerger httpServletResponseMerger, Engine engine, Between prepareCSRF, Between checkCSRF, EncryptSession encryptSession) {
        super(engine, prepareCSRF, checkCSRF, encryptSession);
        this.httpServletRequestTranslator = httpServletRequestTranslator;
        this.httpServletRequestMerger = httpServletRequestMerger;
        this.httpServletResponseMerger = httpServletResponseMerger;
    }

    public GatewayResponse processRequest(HttpServletRequest containerRequest, HttpServletResponse containerResponse, String body) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        try {
            Optional<Response> resourceResponse;
            Request request = this.httpServletRequestTranslator.from(containerRequest, body);
            Response response = new ResponseBuilder().headers(new HashMap<String, String>()).cookies(request.getCookies()).payload(Optional.empty()).presenter(Optional.empty()).template(Optional.empty()).build();
            Boolean shouldHalt = false;
            try {
                resourceResponse = this.engine.route(request, response);
            }
            catch (HaltException e) {
                shouldHalt = true;
                resourceResponse = Optional.of(response);
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            if (!shouldHalt.booleanValue() && !resourceResponse.isPresent()) {
                resourceResponse = Optional.of(this.engine.executeResourceMethod(this.notFoundRoute, request, response));
            }
            this.httpServletResponseMerger.merge(containerResponse, containerRequest.getCookies(), resourceResponse.get());
            this.httpServletRequestMerger.merge(containerRequest, resourceResponse.get());
            if (resourceResponse.get().getPayload().isPresent()) {
                gatewayResponse.setPayload(Optional.of(resourceResponse.get().getPayload().get().toByteArray()));
            } else {
                gatewayResponse.setPayload(Optional.empty());
            }
            gatewayResponse.setTemplate(response.getTemplate());
        }
        catch (IOException | ServletException e) {
            logger.error((Object)e.getMessage(), e);
            containerResponse.setStatus(500);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            containerResponse.setStatus(500);
        }
        return gatewayResponse;
    }
}

