/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.gateway.servlet.merger;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.gateway.servlet.translator.HttpServletRequestCookieTranslator;

public class HttpServletResponseMerger {
    private HttpServletRequestCookieTranslator httpServletRequestCookieTranslator;

    public HttpServletResponseMerger(HttpServletRequestCookieTranslator httpServletRequestCookieTranslator) {
        this.httpServletRequestCookieTranslator = httpServletRequestCookieTranslator;
    }

    public HttpServletResponse merge(HttpServletResponse containerResponse, javax.servlet.http.Cookie[] containerCookies, Response response) throws IOException {
        for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
            containerResponse.setHeader(header.getKey(), header.getValue());
        }
        Map<String, javax.servlet.http.Cookie> containerCookiesMap = this.deleteAndUpdateCookies(containerResponse, containerCookies, response);
        this.createCookies(containerResponse, containerCookiesMap, response.getCookies());
        containerResponse.setStatus(response.getStatusCode().getCode().intValue());
        return containerResponse;
    }

    protected Map<String, javax.servlet.http.Cookie> deleteAndUpdateCookies(HttpServletResponse containerResponse, javax.servlet.http.Cookie[] containerCookies, Response response) {
        HashMap<String, javax.servlet.http.Cookie> containerCookiesMap = new HashMap<String, javax.servlet.http.Cookie>();
        if (containerCookies == null) {
            return containerCookiesMap;
        }
        for (javax.servlet.http.Cookie containerCookie : containerCookies) {
            containerCookiesMap.put(containerCookie.getName(), containerCookie);
            Cookie otterCookie = response.getCookies().get(containerCookie.getName());
            if (otterCookie == null) {
                containerCookie.setMaxAge(0);
                containerResponse.addCookie(containerCookie);
                continue;
            }
            containerCookie = this.httpServletRequestCookieTranslator.to.apply(otterCookie);
            containerResponse.addCookie(containerCookie);
        }
        return containerCookiesMap;
    }

    protected void createCookies(HttpServletResponse containerResponse, Map<String, javax.servlet.http.Cookie> containerCookiesMap, Map<String, Cookie> otterCookies) {
        for (Map.Entry<String, Cookie> otterCookie : otterCookies.entrySet()) {
            javax.servlet.http.Cookie containerCookie = containerCookiesMap.get(otterCookie.getKey());
            if (containerCookie != null) continue;
            javax.servlet.http.Cookie containerCookieToAdd = this.httpServletRequestCookieTranslator.to.apply(otterCookie.getValue());
            containerResponse.addCookie(containerCookieToAdd);
        }
    }
}

