/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.gateway.servlet.translator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.rootservices.otter.QueryStringToMap;
import org.rootservices.otter.controller.builder.RequestBuilder;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.header.ContentType;
import org.rootservices.otter.gateway.servlet.translator.HttpServletRequestCookieTranslator;
import org.rootservices.otter.gateway.servlet.translator.HttpServletRequestHeaderTranslator;
import org.rootservices.otter.router.entity.Method;

public class HttpServletRequestTranslator {
    private static String PARAM_DELIMITER = "?";
    private static String EMPTY = "";
    private HttpServletRequestCookieTranslator httpServletCookieTranslator;
    private HttpServletRequestHeaderTranslator httpServletRequestHeaderTranslator;
    private QueryStringToMap queryStringToMap;

    public HttpServletRequestTranslator(HttpServletRequestCookieTranslator httpServletCookieTranslator, HttpServletRequestHeaderTranslator httpServletRequestHeaderTranslator, QueryStringToMap queryStringToMap) {
        this.httpServletCookieTranslator = httpServletCookieTranslator;
        this.httpServletRequestHeaderTranslator = httpServletRequestHeaderTranslator;
        this.queryStringToMap = queryStringToMap;
    }

    public Request from(HttpServletRequest containerRequest, String containerBody) throws IOException {
        Method method = Method.valueOf(containerRequest.getMethod());
        String pathWithParams = containerRequest.getRequestURI() + this.queryStringForUrl(containerRequest.getQueryString());
        HashMap<String, Cookie> otterCookies = new HashMap();
        if (containerRequest.getCookies() != null) {
            otterCookies = Arrays.asList(containerRequest.getCookies()).stream().collect(Collectors.toMap(javax.servlet.http.Cookie::getName, this.httpServletCookieTranslator.from));
        }
        Map<String, String> headers = this.httpServletRequestHeaderTranslator.from(containerRequest);
        Optional<String> queryString = Optional.ofNullable(containerRequest.getQueryString());
        Map<String, List<String>> queryParams = this.queryStringToMap.run(queryString);
        HashMap<String, List<String>> formData = new HashMap();
        if (method == Method.POST && ContentType.FORM_URL_ENCODED.getValue().equals(containerRequest.getContentType())) {
            formData = this.queryStringToMap.run(Optional.of(containerBody));
        }
        Optional<String> body = Optional.empty();
        if (method == Method.POST && !ContentType.FORM_URL_ENCODED.getValue().equals(containerRequest.getContentType())) {
            body = Optional.of(containerBody);
        }
        String ipAddress = containerRequest.getRemoteAddr();
        return new RequestBuilder().matcher(Optional.empty()).method(method).pathWithParams(pathWithParams).cookies(otterCookies).headers(headers).queryParams(queryParams).formData(formData).body(body).csrfChallenge(Optional.empty()).ipAddress(ipAddress).build();
    }

    protected String queryStringForUrl(String queryString) {
        Object queryStringForUrl = queryString != null ? PARAM_DELIMITER + queryString : EMPTY;
        return queryStringForUrl;
    }
}

