/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.otter.router.entity.MatchedRoute;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.entity.Route;

public class Dispatcher {
    protected static Logger logger = LogManager.getLogger(Dispatcher.class);
    private static String OTTER_PREFIX = "/app";
    private static String EMPTY = "";
    private List<Route> get = new ArrayList<Route>();
    private List<Route> post = new ArrayList<Route>();
    private List<Route> put = new ArrayList<Route>();
    private List<Route> patch = new ArrayList<Route>();
    private List<Route> delete = new ArrayList<Route>();
    private List<Route> connect = new ArrayList<Route>();
    private List<Route> options = new ArrayList<Route>();
    private List<Route> trace = new ArrayList<Route>();
    private List<Route> head = new ArrayList<Route>();

    public Optional<MatchedRoute> find(Method method, String url) {
        String scrubbedUrl = url.replaceAll(OTTER_PREFIX, EMPTY);
        for (Route route : this.routes(method)) {
            Matcher matcher = route.getPattern().matcher(scrubbedUrl);
            if (!matcher.matches()) continue;
            Optional<MatchedRoute> m = Optional.of(new MatchedRoute(matcher, route));
            return m;
        }
        return Optional.empty();
    }

    protected List<Route> routes(Method method) {
        if (method == Method.GET) {
            return this.get;
        }
        if (method == Method.POST) {
            return this.post;
        }
        if (method == Method.PUT) {
            return this.put;
        }
        if (method == Method.PATCH) {
            return this.patch;
        }
        if (method == Method.DELETE) {
            return this.delete;
        }
        if (method == Method.CONNECT) {
            return this.connect;
        }
        if (method == Method.OPTIONS) {
            return this.options;
        }
        if (method == Method.TRACE) {
            return this.trace;
        }
        if (method == Method.HEAD) {
            return this.head;
        }
        return new ArrayList<Route>();
    }

    public List<Route> getGet() {
        return this.get;
    }

    public List<Route> getPost() {
        return this.post;
    }

    public List<Route> getPut() {
        return this.put;
    }

    public List<Route> getPatch() {
        return this.patch;
    }

    public List<Route> getDelete() {
        return this.delete;
    }

    public List<Route> getConnect() {
        return this.connect;
    }

    public List<Route> getOptions() {
        return this.options;
    }

    public List<Route> getTrace() {
        return this.trace;
    }

    public List<Route> getHead() {
        return this.head;
    }
}

