/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.router;

import java.util.List;
import java.util.Optional;
import org.rootservices.otter.controller.Resource;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.router.Dispatcher;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.entity.MatchedRoute;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.entity.Route;
import org.rootservices.otter.router.exception.HaltException;

public class Engine {
    private Dispatcher dispatcher;

    public Engine(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Optional<Response> route(Request request, Response response) throws HaltException {
        Optional<MatchedRoute> matchedRoute = this.dispatcher.find(request.getMethod(), request.getPathWithParams());
        Optional<Response> resourceResponse = Optional.empty();
        if (matchedRoute.isPresent()) {
            request.setMatcher(Optional.of(matchedRoute.get().getMatcher()));
            Response r = this.executeResourceMethod(matchedRoute.get().getRoute(), request, response);
            resourceResponse = Optional.of(r);
        }
        return resourceResponse;
    }

    public Response executeResourceMethod(Route route, Request request, Response response) throws HaltException {
        Resource resource = route.getResource();
        Response resourceResponse = null;
        Method method = request.getMethod();
        this.executeBetween(route.getBefore(), method, request, response);
        if (method == Method.GET) {
            resourceResponse = resource.get(request, response);
        } else if (method == Method.POST) {
            resourceResponse = resource.post(request, response);
        } else if (method == Method.PUT) {
            resourceResponse = resource.put(request, response);
        } else if (method == Method.PATCH) {
            resourceResponse = resource.patch(request, response);
        } else if (method == Method.DELETE) {
            resourceResponse = resource.delete(request, response);
        } else if (method == Method.CONNECT) {
            resourceResponse = resource.connect(request, response);
        } else if (method == Method.OPTIONS) {
            resourceResponse = resource.options(request, response);
        } else if (method == Method.TRACE) {
            resourceResponse = resource.trace(request, response);
        } else if (method == Method.HEAD) {
            resourceResponse = resource.head(request, response);
        }
        this.executeBetween(route.getAfter(), method, request, response);
        return resourceResponse;
    }

    protected void executeBetween(List<Between> betweens, Method method, Request request, Response response) throws HaltException {
        for (Between between : betweens) {
            between.process(method, request, response);
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }
}

