/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.csrf;

import java.io.ByteArrayOutputStream;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.jwt.builder.compact.SecureCompactBuilder;
import org.rootservices.jwt.builder.exception.CompactException;
import org.rootservices.jwt.config.JwtAppFactory;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwk.SymmetricKey;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.exception.InvalidJWT;
import org.rootservices.jwt.exception.SignatureException;
import org.rootservices.jwt.jws.verifier.VerifySignature;
import org.rootservices.jwt.serialization.JwtSerde;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.security.RandomString;
import org.rootservices.otter.security.csrf.CsrfClaims;
import org.rootservices.otter.security.csrf.exception.CsrfException;

public class DoubleSubmitCSRF {
    protected static Logger logger = LogManager.getLogger(DoubleSubmitCSRF.class);
    private JwtAppFactory jwtAppFactory;
    private RandomString randomString;
    private SymmetricKey preferredSignKey;
    private Map<String, SymmetricKey> rotationSignKeys;
    private static String VERIFY_MSG = "Could not verify signature";
    private static String SERIALIZE_JWT = "Could not serialize to compact jwt";
    private static String DE_SERIALIZE_JWT = "Could not deserialize CSRF JWT to pojo";

    public DoubleSubmitCSRF(JwtAppFactory jwtAppFactory, RandomString randomString) {
        this.jwtAppFactory = jwtAppFactory;
        this.randomString = randomString;
    }

    public DoubleSubmitCSRF(JwtAppFactory jwtAppFactory, RandomString randomString, SymmetricKey preferredSignKey, Map<String, SymmetricKey> rotationSignKeys) {
        this.jwtAppFactory = jwtAppFactory;
        this.randomString = randomString;
        this.preferredSignKey = preferredSignKey;
        this.rotationSignKeys = rotationSignKeys;
    }

    public Boolean doTokensMatch(String encodedCsrfCookieValue, String csrfFormValue) {
        Boolean signatureValid;
        JsonWebToken csrfJwt;
        try {
            csrfJwt = this.csrfCookieValueToJwt(encodedCsrfCookieValue);
        }
        catch (CsrfException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        SymmetricKey signKey = this.getSignKey((String)csrfJwt.getHeader().getKeyId().get());
        try {
            signatureValid = this.verifyCsrfCookieSignature(csrfJwt, signKey);
        }
        catch (CsrfException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        CsrfClaims csrfClaims = (CsrfClaims)csrfJwt.getClaims();
        if (signatureValid.booleanValue() && csrfClaims.getChallengeToken().equals(csrfFormValue)) {
            return true;
        }
        return false;
    }

    public JsonWebToken csrfCookieValueToJwt(String encodedCsrfCookieValue) throws CsrfException {
        JsonWebToken jsonWebToken;
        JwtSerde jwtSerde = this.jwtAppFactory.jwtSerde();
        try {
            jsonWebToken = jwtSerde.stringToJwt(encodedCsrfCookieValue, CsrfClaims.class);
        }
        catch (JsonToJwtException e) {
            throw new CsrfException(DE_SERIALIZE_JWT, e);
        }
        catch (InvalidJWT e) {
            throw new CsrfException(DE_SERIALIZE_JWT, e);
        }
        return jsonWebToken;
    }

    protected SymmetricKey getSignKey(String keyId) {
        SymmetricKey key = ((String)this.preferredSignKey.getKeyId().get()).equals(keyId) ? this.preferredSignKey : this.rotationSignKeys.get(keyId);
        return key;
    }

    protected Boolean verifyCsrfCookieSignature(JsonWebToken csrfJwt, SymmetricKey signKey) throws CsrfException {
        VerifySignature verifySignature;
        try {
            verifySignature = this.jwtAppFactory.verifySignature(csrfJwt.getHeader().getAlgorithm(), (Key)signKey);
        }
        catch (SignatureException e) {
            throw new CsrfException(VERIFY_MSG, e);
        }
        return verifySignature.run(csrfJwt);
    }

    public String makeChallengeToken() {
        return this.randomString.run();
    }

    public Cookie makeCsrfCookie(String name, String challengeToken, Boolean secure, int maxAge) throws CsrfException {
        ByteArrayOutputStream compactJwt;
        Optional<Long> issuedAt = Optional.of(OffsetDateTime.now().toEpochSecond());
        CsrfClaims csrfClaims = new CsrfClaims();
        csrfClaims.setChallengeToken(challengeToken);
        csrfClaims.setIssuedAt(issuedAt);
        SecureCompactBuilder compactBuilder = new SecureCompactBuilder();
        try {
            compactJwt = compactBuilder.alg(Algorithm.HS256).key((Key)this.preferredSignKey).claims((Claims)csrfClaims).build();
        }
        catch (CompactException e) {
            throw new CsrfException(SERIALIZE_JWT, e);
        }
        Cookie csrfCookie = new Cookie();
        csrfCookie.setSecure(secure);
        csrfCookie.setName(name);
        csrfCookie.setMaxAge(maxAge);
        csrfCookie.setValue(compactJwt.toString());
        return csrfCookie;
    }

    public void setPreferredSignKey(SymmetricKey preferredSignKey) {
        this.preferredSignKey = preferredSignKey;
    }

    public void setRotationSignKeys(Map<String, SymmetricKey> rotationSignKeys) {
        this.rotationSignKeys = rotationSignKeys;
    }
}

