/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.csrf;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.rootservices.otter.security.RandomString;
import org.rootservices.otter.security.csrf.Csrf;
import org.rootservices.otter.security.csrf.exception.CsrfException;

public class SynchronizerToken
implements Csrf {
    private static String POST = "POST";
    private static String PUT = "PUT";
    private static String DELETE = "DELETE";
    protected static String CHALLENGE_TOKEN_SESSION_NAME = "csrfToken";
    protected static String CHALLENGE_TOKEN_FORM_NAME = "csrfToken";
    private RandomString randomString;

    public SynchronizerToken(RandomString randomString) {
        this.randomString = randomString;
    }

    @Override
    public void checkTokens(HttpServletRequest httpRequest) throws CsrfException {
        Optional<String> sessionChallengeToken = this.getChallengeTokenFromSession(httpRequest);
        if (this.requestMethodRequiresChallengeToken(httpRequest.getMethod())) {
            Optional<String> formChallengeToken = this.getChallengeTokenFromForm(httpRequest);
            if (!this.doTokensMatch(sessionChallengeToken, formChallengeToken)) {
                throw new CsrfException("challenge tokens do not match");
            }
        } else if (!sessionChallengeToken.isPresent()) {
            this.insertChallengeTokenIntoSession(httpRequest);
        }
    }

    protected boolean doTokensMatch(Optional<String> sessionChallengeToken, Optional<String> formChallengeToken) {
        if (!sessionChallengeToken.isPresent() || !formChallengeToken.isPresent()) {
            return false;
        }
        return sessionChallengeToken.get().equals(formChallengeToken.get());
    }

    protected boolean requestMethodRequiresChallengeToken(String method) {
        return POST.equalsIgnoreCase(method) || PUT.equalsIgnoreCase(method) || DELETE.equalsIgnoreCase(method);
    }

    protected Optional<String> getChallengeTokenFromSession(HttpServletRequest request) {
        return Optional.ofNullable((String)request.getSession().getAttribute(CHALLENGE_TOKEN_SESSION_NAME));
    }

    protected void insertChallengeTokenIntoSession(HttpServletRequest request) throws CsrfException {
        byte[] bytes;
        String challengeToken = this.randomString.run();
        try {
            bytes = challengeToken.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CsrfException("could not encode challenge token");
        }
        String encodedChallengeToken = Base64.getEncoder().encodeToString(bytes);
        request.getSession().setAttribute(CHALLENGE_TOKEN_SESSION_NAME, (Object)encodedChallengeToken);
    }

    protected Optional<String> getChallengeTokenFromForm(HttpServletRequest request) {
        return Optional.ofNullable(request.getParameter(CHALLENGE_TOKEN_FORM_NAME));
    }
}

