/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.csrf.between;

import java.util.List;
import java.util.Optional;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.controller.entity.StatusCode;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.exception.CsrfException;
import org.rootservices.otter.router.exception.HaltException;
import org.rootservices.otter.security.csrf.DoubleSubmitCSRF;

public class CheckCSRF
implements Between {
    private String cookieName;
    private String formFieldName;
    private DoubleSubmitCSRF doubleSubmitCSRF;
    private static String HALT_MSG = "CSRF failed.";

    public CheckCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    public CheckCSRF(String cookieName, String formFieldName, DoubleSubmitCSRF doubleSubmitCSRF) {
        this.cookieName = cookieName;
        this.formFieldName = formFieldName;
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    @Override
    public void process(Method method, Request request, Response response) throws HaltException {
        Cookie csrfCookie = request.getCookies().get(this.cookieName);
        List<String> formValue = request.getFormData().get(this.formFieldName);
        Boolean ok = csrfCookie != null && formValue != null && formValue.size() == 1 ? this.doubleSubmitCSRF.doTokensMatch(csrfCookie.getValue(), formValue.get(0)) : Boolean.valueOf(false);
        if (!ok.booleanValue()) {
            response.setStatusCode(StatusCode.FORBIDDEN);
            throw new CsrfException(HALT_MSG);
        }
        request.setCsrfChallenge(Optional.of(formValue.get(0)));
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getFormFieldName() {
        return this.formFieldName;
    }

    public void setFormFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
    }

    public DoubleSubmitCSRF getDoubleSubmitCSRF() {
        return this.doubleSubmitCSRF;
    }

    public void setDoubleSubmitCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }
}

