/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.csrf.between;

import java.util.Optional;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.otter.config.CookieConfig;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.exception.HaltException;
import org.rootservices.otter.security.csrf.CsrfClaims;
import org.rootservices.otter.security.csrf.DoubleSubmitCSRF;
import org.rootservices.otter.security.csrf.exception.CsrfException;

public class PrepareCSRF
implements Between {
    protected static Logger logger = LogManager.getLogger(PrepareCSRF.class);
    private CookieConfig cookieConfig;
    private DoubleSubmitCSRF doubleSubmitCSRF;

    public PrepareCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    public PrepareCSRF(CookieConfig cookieConfig, DoubleSubmitCSRF doubleSubmitCSRF) {
        this.cookieConfig = cookieConfig;
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    @Override
    public void process(Method method, Request request, Response response) throws HaltException {
        if (response.getCookies().get(this.cookieConfig.getName()) == null) {
            String challengeToken = this.doubleSubmitCSRF.makeChallengeToken();
            try {
                Cookie csrfCookie = this.doubleSubmitCSRF.makeCsrfCookie(this.cookieConfig.getName(), challengeToken, this.cookieConfig.getSecure(), this.cookieConfig.getAge());
                response.getCookies().put(this.cookieConfig.getName(), csrfCookie);
                request.setCsrfChallenge(Optional.of(challengeToken));
            }
            catch (CsrfException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            JsonWebToken csrfJwt = null;
            try {
                csrfJwt = this.doubleSubmitCSRF.csrfCookieValueToJwt(response.getCookies().get(this.cookieConfig.getName()).getValue());
            }
            catch (CsrfException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            CsrfClaims claims = (CsrfClaims)csrfJwt.getClaims();
            request.setCsrfChallenge(Optional.of(claims.getChallengeToken()));
        }
    }

    public CookieConfig getCookieConfig() {
        return this.cookieConfig;
    }

    public void setCookieConfig(CookieConfig cookieConfig) {
        this.cookieConfig = cookieConfig;
    }

    public DoubleSubmitCSRF getDoubleSubmitCSRF() {
        return this.doubleSubmitCSRF;
    }

    public void setDoubleSubmitCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }
}

