/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.session.between;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.jwt.config.JwtAppFactory;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwk.SymmetricKey;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.exception.InvalidJWT;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwe.serialization.direct.JweDirectDesializer;
import org.rootservices.jwt.jwe.serialization.exception.KeyException;
import org.rootservices.jwt.serialization.HeaderDeserializer;
import org.rootservices.jwt.serialization.exception.DecryptException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.controller.entity.StatusCode;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.exception.HaltException;
import org.rootservices.otter.security.session.Session;
import org.rootservices.otter.security.session.between.exception.InvalidSessionException;
import org.rootservices.otter.security.session.between.exception.SessionCtorException;
import org.rootservices.otter.security.session.between.exception.SessionDecryptException;

public class DecryptSession<T extends Session>
implements Between {
    public static final String NOT_A_JWT = "Session cookie was not a JWE: %s";
    public static final String COULD_NOT_GET_HEADER_JWE = "Session cookie did have a header member: %s";
    public static final String COULD_NOT_DESERIALIZE_JWE = "Session cookie could not be de-serialized to JSON: %s";
    public static final String COULD_NOT_DECRYPT_JWE = "Session cookie could not be decrypted: %s";
    public static final String COULD_NOT_DESERIALIZE = "decrypted payload could be deserialized to session: %s";
    public static final String INVALID_SESSION_COOKIE = "Invalid value for the session cookie";
    public static final String COOKIE_NOT_PRESENT = "session cookie not present.";
    public static final String FAILED_TO_COPY_REQUEST_SESSION = "failed to copy request session";
    public static final String COULD_NOT_ACCESS_SESSION_CTORS = "Could not access session constructors";
    public static final String COULD_NOT_CALL_THE_SESSION_COPY_CONSTRUCTOR = "Could not call the session's copy constructor";
    protected static Logger LOGGER = LogManager.getLogger(DecryptSession.class);
    private Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private String sessionCookieName;
    private JwtAppFactory jwtAppFactory;
    private SymmetricKey preferredKey;
    private Map<String, SymmetricKey> rotationKeys;
    private ObjectMapper objectMapper;

    public DecryptSession(String sessionCookieName, JwtAppFactory jwtAppFactory, SymmetricKey preferredKey, Map<String, SymmetricKey> rotationKeys, ObjectMapper objectMapper) {
        this.sessionCookieName = sessionCookieName;
        this.jwtAppFactory = jwtAppFactory;
        this.preferredKey = preferredKey;
        this.rotationKeys = rotationKeys;
        this.objectMapper = objectMapper;
    }

    @Override
    public void process(Method method, Request request, Response response) throws HaltException {
        Session responseSession;
        Optional<Session> session;
        Cookie sessionCookie = request.getCookies().get(this.sessionCookieName);
        if (sessionCookie == null) {
            HaltException halt = new HaltException(COOKIE_NOT_PRESENT);
            this.onHalt(halt, response);
            throw halt;
        }
        try {
            session = Optional.of(this.decrypt(sessionCookie.getValue()));
        }
        catch (InvalidSessionException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(INVALID_SESSION_COOKIE, e);
            this.onHalt(halt, response);
            throw halt;
        }
        catch (SessionDecryptException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(INVALID_SESSION_COOKIE, e);
            this.onHalt(halt, response);
            throw halt;
        }
        request.setSession(session);
        try {
            responseSession = this.copy(session.get());
        }
        catch (SessionCtorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(FAILED_TO_COPY_REQUEST_SESSION, e);
            this.onHalt(halt, response);
            throw halt;
        }
        response.setSession(Optional.of(responseSession));
    }

    protected T copy(T session) throws SessionCtorException {
        Constructor ctor;
        Session copy = null;
        try {
            ctor = this.clazz.getConstructor(this.clazz);
        }
        catch (NoSuchMethodException e) {
            throw new SessionCtorException(COULD_NOT_ACCESS_SESSION_CTORS, e);
        }
        try {
            copy = (Session)ctor.newInstance(session);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SessionCtorException(COULD_NOT_CALL_THE_SESSION_COPY_CONSTRUCTOR, e);
        }
        return (T)copy;
    }

    protected void onHalt(HaltException e, Response response) {
        response.setStatusCode(StatusCode.UNAUTHORIZED);
        response.getCookies().remove(this.sessionCookieName);
    }

    protected T decrypt(String encryptedSession) throws InvalidSessionException, SessionDecryptException {
        JWE sessionPayload;
        Header sessionHeader;
        HeaderDeserializer headerDeserializer = this.jwtAppFactory.headerDeserializer();
        try {
            sessionHeader = headerDeserializer.toHeader(encryptedSession);
        }
        catch (JsonToJwtException e) {
            String msg = String.format(NOT_A_JWT, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        catch (InvalidJWT e) {
            String msg = String.format(COULD_NOT_GET_HEADER_JWE, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        SymmetricKey key = this.getKey((String)sessionHeader.getKeyId().get());
        JweDirectDesializer deserializer = this.jwtAppFactory.jweDirectDesializer();
        try {
            sessionPayload = deserializer.stringToJWE(encryptedSession, (Key)key);
        }
        catch (JsonToJwtException e) {
            String msg = String.format(COULD_NOT_DESERIALIZE_JWE, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        catch (CipherException | KeyException | DecryptException e) {
            String msg = String.format(COULD_NOT_DECRYPT_JWE, encryptedSession);
            throw new SessionDecryptException(msg, e);
        }
        return this.toSession(sessionPayload.getPayload());
    }

    protected T toSession(byte[] json) {
        Session session = null;
        try {
            session = (Session)this.objectMapper.readValue(json, this.clazz);
        }
        catch (IOException e) {
            String msg = String.format(COULD_NOT_DESERIALIZE, new String(json, StandardCharsets.UTF_8));
            LOGGER.error((Object)msg);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return (T)session;
    }

    protected SymmetricKey getKey(String keyId) {
        SymmetricKey key = ((String)this.preferredKey.getKeyId().get()).equals(keyId) ? this.preferredKey : this.rotationKeys.get(keyId);
        return key;
    }
}

