/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.security.session.between;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.jwt.builder.compact.EncryptedCompactBuilder;
import org.rootservices.jwt.builder.exception.CompactException;
import org.rootservices.jwt.config.JwtAppFactory;
import org.rootservices.jwt.entity.jwe.EncryptionAlgorithm;
import org.rootservices.jwt.entity.jwk.SymmetricKey;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.otter.config.CookieConfig;
import org.rootservices.otter.controller.entity.Cookie;
import org.rootservices.otter.controller.entity.Request;
import org.rootservices.otter.controller.entity.Response;
import org.rootservices.otter.router.entity.Between;
import org.rootservices.otter.router.entity.Method;
import org.rootservices.otter.router.exception.HaltException;
import org.rootservices.otter.security.session.Session;
import org.rootservices.otter.security.session.between.exception.EncryptSessionException;

public class EncryptSession
implements Between {
    public static final String NOT_ENCRPTING = "Not re-encrypting session cookie";
    public static final String COULD_NOT_ENCRYPT_SESSION = "Could not encrypt session cookie";
    protected static Logger LOGGER = LogManager.getLogger(EncryptSession.class);
    private CookieConfig cookieConfig;
    private JwtAppFactory jwtAppFactory;
    private Base64.Decoder decoder;
    private SymmetricKey preferredKey;
    private ObjectMapper objectMapper;

    public EncryptSession(JwtAppFactory jwtAppFactory, Base64.Decoder decoder, ObjectMapper objectMapper) {
        this.jwtAppFactory = jwtAppFactory;
        this.decoder = decoder;
        this.objectMapper = objectMapper;
    }

    public EncryptSession(CookieConfig cookieConfig, JwtAppFactory jwtAppFactory, Base64.Decoder decoder, SymmetricKey preferredKey, ObjectMapper objectMapper) {
        this.cookieConfig = cookieConfig;
        this.jwtAppFactory = jwtAppFactory;
        this.decoder = decoder;
        this.preferredKey = preferredKey;
        this.objectMapper = objectMapper;
    }

    @Override
    public void process(Method method, Request request, Response response) throws HaltException {
        if (this.shouldEncrypt(request, response).booleanValue()) {
            ByteArrayOutputStream session;
            try {
                session = this.encrypt(response.getSession().get());
            }
            catch (EncryptSessionException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new HaltException(COULD_NOT_ENCRYPT_SESSION, e);
            }
            Cookie cookie = new Cookie();
            cookie.setName(this.cookieConfig.getName());
            cookie.setMaxAge(this.cookieConfig.getAge());
            cookie.setSecure(this.cookieConfig.getSecure());
            cookie.setValue(session.toString());
            response.getCookies().put(this.cookieConfig.getName(), cookie);
        } else {
            LOGGER.debug((Object)NOT_ENCRPTING);
        }
    }

    protected Boolean shouldEncrypt(Request request, Response response) {
        if (request.getSession().isPresent() && response.getSession().isPresent()) {
            if (response.getSession().get().equals(request.getSession().get())) {
                return false;
            }
            return true;
        }
        if (response.getSession().isPresent()) {
            return true;
        }
        return false;
    }

    protected ByteArrayOutputStream encrypt(Session session) throws EncryptSessionException {
        ByteArrayOutputStream compactJwe;
        byte[] payload;
        try {
            payload = this.objectMapper.writeValueAsBytes((Object)session);
        }
        catch (JsonProcessingException e) {
            throw new EncryptSessionException(e.getMessage(), e);
        }
        EncryptedCompactBuilder compactBuilder = new EncryptedCompactBuilder();
        try {
            compactJwe = compactBuilder.encAlg(EncryptionAlgorithm.AES_GCM_256).alg(Algorithm.DIRECT).payload(payload).cek(this.preferredKey).build();
        }
        catch (CompactException e) {
            throw new EncryptSessionException(e.getMessage(), e);
        }
        return compactJwe;
    }

    public CookieConfig getCookieConfig() {
        return this.cookieConfig;
    }

    public void setCookieConfig(CookieConfig cookieConfig) {
        this.cookieConfig = cookieConfig;
    }

    public SymmetricKey getPreferredKey() {
        return this.preferredKey;
    }

    public void setPreferredKey(SymmetricKey preferredKey) {
        this.preferredKey = preferredKey;
    }
}

