/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.server.container;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.rootservices.otter.server.container.ServletContainer;
import org.rootservices.otter.server.container.ServletContainerImpl;
import org.rootservices.otter.server.container.builder.WebAppContextBuilder;
import org.rootservices.otter.server.path.CompiledClassPath;
import org.rootservices.otter.server.path.WebAppPath;
import org.rootservices.otter.servlet.EntryFilter;

public class ServletContainerFactory {
    protected static Logger logger = LogManager.getLogger(ServletContainerFactory.class);
    private static String DIR_ALLOWED_KEY = "org.eclipse.jetty.servlet.Default.dirAllowed";
    private static String INCLUDE_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    private static String JARS_TO_INCLUDE = ".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$";
    private static String JSP_SERVLET = "org.eclipse.jetty.jsp.JettyJspServlet";
    private static String FALSE = "false";
    private CompiledClassPath compiledClassPath;
    private WebAppPath webAppPath;

    public ServletContainerFactory(CompiledClassPath compiledClassPath, WebAppPath webAppPath) {
        this.compiledClassPath = compiledClassPath;
        this.webAppPath = webAppPath;
    }

    public ServletContainer makeServletContainer(String documentRoot, Class clazz, int port, String requestLog) throws URISyntaxException, IOException {
        URI compliedClassPath = this.compiledClassPath.getForClass(clazz);
        URI webApp = this.webAppPath.fromClassURI(compliedClassPath);
        return this.makeServletContainer(documentRoot, webApp, compliedClassPath, port, requestLog);
    }

    public ServletContainer makeServletContainer(String documentRoot, Class clazz, String customWebAppLocation, int port, String requestLog) throws URISyntaxException, IOException {
        URI compliedClassPath = this.compiledClassPath.getForClass(clazz);
        URI webApp = this.webAppPath.fromClassURI(compliedClassPath, customWebAppLocation);
        return this.makeServletContainer(documentRoot, webApp, compliedClassPath, port, requestLog);
    }

    public ServletContainer makeServletContainer(String documentRoot, URI webApp, URI compliedClassPath, int port, String requestLog) throws IOException {
        WebAppContext context;
        logger.debug((Object)("Web App location: " + webApp.toURL()));
        logger.debug((Object)("Compiled Class path: " + compliedClassPath.toURL()));
        Server jetty = new Server(port);
        Configuration[] configurations = this.makeConfigurations();
        PathResource containerResources = this.makeFileResource(compliedClassPath);
        String resourceBase = this.makeResourceBase(webApp);
        if (compliedClassPath.toURL().getFile().endsWith("war")) {
            logger.debug((Object)"Using a war file");
            context = this.makeWebAppContextForWAR(documentRoot, configurations, (Resource)containerResources);
        } else {
            logger.debug((Object)"Not a war file");
            context = this.makeWebAppContext(documentRoot, resourceBase, configurations, containerResources);
        }
        jetty.setHandler((Handler)context);
        ServerConnector serverConnector = this.makeServerConnector(jetty, port);
        jetty.setConnectors(new Connector[]{serverConnector});
        NCSARequestLog log = this.makeRequestLog(requestLog);
        jetty.setRequestLog((RequestLog)log);
        ServletContainerImpl server = new ServletContainerImpl(jetty);
        return server;
    }

    public ServletContainer makeServletContainerFromWar(String documentRoot, URI warFilePath, int port, String requestLog) throws IOException {
        Configuration[] configurations = this.makeConfigurations();
        PathResource warFileResource = this.makeFileResource(warFilePath);
        WebAppContext context = this.makeWebAppContextForWAR(documentRoot, configurations, (Resource)warFileResource);
        Server jetty = new Server(port);
        jetty.setHandler((Handler)context);
        ServerConnector serverConnector = this.makeServerConnector(jetty, port);
        jetty.setConnectors(new Connector[]{serverConnector});
        NCSARequestLog log = this.makeRequestLog(requestLog);
        jetty.setRequestLog((RequestLog)log);
        ServletContainerImpl server = new ServletContainerImpl(jetty);
        return server;
    }

    protected WebAppContext makeWebAppContext(String documentRoot, String resourceBase, Configuration[] configurations, PathResource containerResources) {
        WebAppContext webAppContext = new WebAppContextBuilder().classLoader(Thread.currentThread().getContextClassLoader()).resourceBase(resourceBase).configurations(configurations).containerResource(containerResources).initParameter(DIR_ALLOWED_KEY, FALSE).contextPath(documentRoot).parentLoaderPriority(true).attribute(INCLUDE_JAR_PATTERN, JARS_TO_INCLUDE).jspServlet(JSP_SERVLET).errorPageHandler(404, "/notFound").stateless().staticAssetServlet(resourceBase + "/public/").build();
        webAppContext.addFilter(EntryFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        return webAppContext;
    }

    protected WebAppContext makeWebAppContextForWAR(String documentRoot, Configuration[] configurations, Resource war) {
        logger.debug((Object)("war: " + war.getURI().toString()));
        WebAppContext webAppContext = new WebAppContextBuilder().classLoader(Thread.currentThread().getContextClassLoader()).configurations(configurations).initParameter(DIR_ALLOWED_KEY, FALSE).contextPath(documentRoot).parentLoaderPriority(true).attribute(INCLUDE_JAR_PATTERN, JARS_TO_INCLUDE).jspServlet(JSP_SERVLET).errorPageHandler(404, "/notFound").stateless().staticAssetServletWar("/public/").build();
        webAppContext.addFilter(EntryFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        webAppContext.setExtractWAR(true);
        webAppContext.setWarResource(war);
        return webAppContext;
    }

    protected String makeResourceBase(URI webApp) throws MalformedURLException {
        Resource resourceBase = Resource.newResource((URI)webApp);
        return String.valueOf(resourceBase);
    }

    protected PathResource makeFileResource(URI classPath) throws IOException {
        return new PathResource(classPath);
    }

    protected Configuration[] makeConfigurations() {
        return new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration()};
    }

    protected ServerConnector makeServerConnector(Server server, int port) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{httpFactory});
        serverConnector.setPort(port);
        return serverConnector;
    }

    protected NCSARequestLog makeRequestLog(String logFile) {
        NCSARequestLog requestLog = new NCSARequestLog(logFile);
        requestLog.setAppend(true);
        requestLog.setExtended(false);
        requestLog.setLogTimeZone("GMT");
        requestLog.setLogLatency(true);
        requestLog.setRetainDays(90);
        return requestLog;
    }
}

