/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.server.container.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppContextBuilder {
    private ClassLoader classLoader;
    private String contextPath;
    private String resourceBase;
    private Configuration[] configurations;
    private File tempDirectory;
    private PathResource containerResource;
    private Boolean parentLoaderPriority;
    private Map<String, String> initParameters = new HashMap<String, String>();
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<ServletHolder> servletHolders = new ArrayList<ServletHolder>();
    private List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
    private SessionHandler sessionHandler;

    public WebAppContextBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public WebAppContextBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public WebAppContextBuilder resourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
        return this;
    }

    public WebAppContextBuilder configurations(Configuration[] configurations) {
        this.configurations = configurations;
        return this;
    }

    public WebAppContextBuilder tempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
        return this;
    }

    public WebAppContextBuilder containerResource(PathResource containerResource) {
        this.containerResource = containerResource;
        return this;
    }

    public WebAppContextBuilder parentLoaderPriority(Boolean parentLoaderPriority) {
        this.parentLoaderPriority = parentLoaderPriority;
        return this;
    }

    public WebAppContextBuilder initParameter(String key, String value) {
        this.initParameters.put(key, value);
        return this;
    }

    public WebAppContextBuilder attribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public WebAppContextBuilder jspServlet(String className) {
        ServletHolder jspHolder = new ServletHolder();
        jspHolder.setName("jsp");
        jspHolder.setClassName(className);
        jspHolder.setInitParameter("async-supported", "true");
        jspHolder.setInitParameter("fork", "false");
        this.servletHolders.add(jspHolder);
        return this;
    }

    public WebAppContextBuilder staticAssetServlet(String resourceBase) {
        ServletHolder defaultServletHolder = new ServletHolder("default", DefaultServlet.class);
        defaultServletHolder.setInitParameter("resourceBase", resourceBase);
        this.servletHolders.add(defaultServletHolder);
        return this;
    }

    public WebAppContextBuilder staticAssetServletWar(String relativeResourceBase) {
        ServletHolder defaultServletHolder = new ServletHolder("default", DefaultServlet.class);
        defaultServletHolder.setInitParameter("relativeResourceBase", this.resourceBase);
        this.servletHolders.add(defaultServletHolder);
        return this;
    }

    public WebAppContextBuilder errorPageHandler(int statusCode, String location) {
        ErrorPage errorPage = new ErrorPage();
        errorPage.setErrorCode(statusCode);
        errorPage.setLocation(location);
        this.errorPages.add(errorPage);
        return this;
    }

    public WebAppContextBuilder stateless() {
        this.sessionHandler = new SessionHandler();
        this.sessionHandler.setUsingCookies(false);
        return this;
    }

    public WebAppContext build() {
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setClassLoader(this.classLoader);
        if (this.resourceBase != null) {
            webAppContext.setResourceBase(this.resourceBase);
        }
        webAppContext.setConfigurations(this.configurations);
        webAppContext.setTempDirectory(this.tempDirectory);
        if (this.containerResource != null) {
            webAppContext.getMetaData().addContainerResource((Resource)this.containerResource);
        }
        webAppContext.setParentLoaderPriority(this.parentLoaderPriority.booleanValue());
        for (Map.Entry<String, String> entry : this.initParameters.entrySet()) {
            webAppContext.setInitParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            webAppContext.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        int maxInitOrder = 0;
        for (ServletHolder servletHolder : webAppContext.getServletHandler().getServlets()) {
            if (servletHolder.getInitOrder() <= maxInitOrder) continue;
            maxInitOrder = servletHolder.getInitOrder();
        }
        for (ServletHolder holder : this.servletHolders) {
            holder.setInitOrder(++maxInitOrder);
            webAppContext.getServletHandler().addServlet(holder);
        }
        ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)webAppContext.getErrorHandler();
        for (ErrorPage errorPage : this.errorPages) {
            errorPageErrorHandler.addErrorPage(errorPage.getErrorCode(), errorPage.getLocation());
        }
        webAppContext.setSessionHandler(this.sessionHandler);
        return webAppContext;
    }
}

