/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.servlet;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;

@WebFilter(filterName="EntryFilter", asyncSupported=true, urlPatterns={"/*"})
public class EntryFilter
implements Filter {
    protected static Pattern TEMPLATE_PATTERN = Pattern.compile("(.*).(jsp|jspf|jspx|xsp|JSP|JSPF|JSPX|XSP|js|css)");
    protected static Pattern STATIC_ASSETS_PATTERN = Pattern.compile("(.*).(js|css)");
    protected static String OTTER_PREFIX = "/app";
    protected static String FORWARD_URI = OTTER_PREFIX + "%s";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String context = req.getRequestURI();
        Matcher templateMatcher = TEMPLATE_PATTERN.matcher(context);
        Matcher staticAssetsMatcher = STATIC_ASSETS_PATTERN.matcher(context);
        if (templateMatcher.matches() || staticAssetsMatcher.matches()) {
            chain.doFilter(request, response);
        } else {
            request.getRequestDispatcher(String.format(FORWARD_URI, context)).forward(request, response);
        }
    }

    public void destroy() {
    }
}

