/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.servlet;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.otter.config.OtterAppFactory;
import org.rootservices.otter.gateway.Configure;
import org.rootservices.otter.gateway.servlet.ServletGateway;
import org.rootservices.otter.servlet.async.OtterAsyncListener;
import org.rootservices.otter.servlet.async.ReadListenerImpl;

public abstract class OtterEntryServlet
extends HttpServlet {
    protected static Logger logger = LogManager.getLogger(OtterEntryServlet.class);
    protected OtterAppFactory otterAppFactory;
    protected ServletGateway servletGateway;

    public void init() {
        this.otterAppFactory = new OtterAppFactory();
        this.servletGateway = this.otterAppFactory.servletGateway();
        Configure configure = this.makeConfigure();
        configure.configure(this.servletGateway);
        configure.routes(this.servletGateway);
    }

    public abstract Configure makeConfigure();

    public void doAsync(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
        OtterAsyncListener asyncListener = new OtterAsyncListener();
        context.addListener((AsyncListener)asyncListener);
        ServletInputStream input = request.getInputStream();
        ReadListenerImpl readListener = new ReadListenerImpl(this.servletGateway, input, context);
        input.setReadListener((ReadListener)readListener);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }
}

