/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.servlet.async;

import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.AsyncContextEvent;

public class OtterAsyncListener
implements AsyncListener {
    protected static Logger logger = LogManager.getLogger(OtterAsyncListener.class);

    public void onComplete(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        logger.debug((Object)("Async Done: " + hsr.getMethod() + " " + ace.getPath()));
    }

    public void onError(AsyncEvent event) {
        Throwable t = event.getThrowable();
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        String msg = "Error: " + hsr.getMethod() + " " + ace.getPath() + " " + t.getMessage();
        logger.error((Object)msg, t);
    }

    public void onStartAsync(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        logger.debug((Object)("Async Started: " + hsr.getMethod() + " " + ace.getPath()));
    }

    public void onTimeout(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        logger.error((Object)("Async timeout: " + hsr.getMethod() + " " + ace.getPath()));
    }
}

