/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.servlet.async;

import java.io.IOException;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.rootservices.otter.gateway.servlet.GatewayResponse;
import org.rootservices.otter.gateway.servlet.ServletGateway;
import org.rootservices.otter.servlet.async.WriteListenerImpl;

public class ReadListenerImpl
implements ReadListener {
    protected static Logger logger = LogManager.getLogger(ReadListenerImpl.class);
    private ServletGateway servletGateway;
    private ServletInputStream input = null;
    private AsyncContext ac = null;
    private Queue queue = new LinkedBlockingQueue();

    public ReadListenerImpl(ServletGateway sg, ServletInputStream in, AsyncContext c) {
        this.servletGateway = sg;
        this.input = in;
        this.ac = c;
    }

    public void onDataAvailable() throws IOException {
        StringBuilder sb = new StringBuilder();
        int len = -1;
        byte[] b = new byte[1024];
        while (this.input.isReady() && (len = this.input.read(b)) != -1 && !this.input.isFinished()) {
            String data = new String(b, 0, len);
            sb.append(data);
        }
        this.queue.add(sb.toString());
    }

    public void onAllDataRead() throws IOException {
        String body;
        HttpServletResponse response;
        HttpServletRequest request = (HttpServletRequest)this.ac.getRequest();
        GatewayResponse gatewayResponse = this.servletGateway.processRequest(request, response = (HttpServletResponse)this.ac.getResponse(), body = this.queueToString(this.queue));
        if (gatewayResponse.getPayload().isPresent()) {
            Queue out = this.byteArrayToQueue(gatewayResponse.getPayload().get(), 1024);
            ServletOutputStream output = response.getOutputStream();
            WriteListenerImpl writeListener = new WriteListenerImpl(output, out, this.ac);
            output.setWriteListener((WriteListener)writeListener);
        } else if (gatewayResponse.getTemplate().isPresent()) {
            this.ac.dispatch(request.getServletContext(), gatewayResponse.getTemplate().get());
        } else {
            this.ac.complete();
        }
    }

    public String queueToString(Queue queue) {
        StringBuilder sb = new StringBuilder();
        while (queue.peek() != null) {
            String data = (String)queue.poll();
            sb.append(data);
        }
        return sb.toString();
    }

    public void onError(Throwable t) {
        logger.error((Object)t.getMessage(), t);
        this.ac.complete();
    }

    public Queue byteArrayToQueue(byte[] source, int chunksize) {
        LinkedBlockingQueue<byte[]> out = new LinkedBlockingQueue<byte[]>();
        for (int start = 0; start < source.length; start += chunksize) {
            int end = Math.min(source.length, start + chunksize);
            out.add(Arrays.copyOfRange(source, start, end));
        }
        return out;
    }
}

