/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.otter.translator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rootservices.otter.translatable.Translatable;
import org.rootservices.otter.translator.exception.DuplicateKeyException;
import org.rootservices.otter.translator.exception.InvalidPayloadException;
import org.rootservices.otter.translator.exception.InvalidValueException;
import org.rootservices.otter.translator.exception.ToJsonException;
import org.rootservices.otter.translator.exception.UnknownKeyException;

public class JsonTranslator<T extends Translatable> {
    private ObjectMapper objectMapper;
    private static final String DUPLICATE_NAME = "key";
    private static final Pattern DUPLICATE_KEY_PATTERN = Pattern.compile("Duplicate field '(?<key>\\w+)'");
    private static final String DUPLICATE_KEY_MSG = "The key '%s' was duplicated";
    private static final String UNKNOWN_KEY_MSG = "The key '%s' was not expected";
    private static final String INVALID_VALUE_MSG = "The key '%s' had an invalid value";
    private static final String INVALID_PAYLOAD_MSG = "The payload couldn't be parsed";
    private static final String TO_JSON_MSG = "Could not create JSON";

    public JsonTranslator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public T from(String json, Class<? extends Translatable> clazz) throws InvalidPayloadException, DuplicateKeyException, UnknownKeyException, InvalidValueException {
        Translatable entity = null;
        try {
            entity = (Translatable)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            this.handleJsonParseException(e);
        }
        catch (UnrecognizedPropertyException e) {
            String msg = String.format(UNKNOWN_KEY_MSG, e.getPropertyName());
            throw new UnknownKeyException(msg, e, e.getPropertyName());
        }
        catch (InvalidFormatException e) {
            String key = ((JsonMappingException.Reference)e.getPath().get(0)).getFieldName();
            String msg = String.format(INVALID_VALUE_MSG, key);
            throw new InvalidValueException(msg, e, key);
        }
        catch (JsonMappingException e) {
            throw new InvalidPayloadException(INVALID_PAYLOAD_MSG, e);
        }
        catch (IOException e) {
            throw new InvalidPayloadException(INVALID_PAYLOAD_MSG, e);
        }
        return (T)entity;
    }

    public ByteArrayOutputStream to(Object object) throws ToJsonException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue((OutputStream)out, object);
        }
        catch (JsonProcessingException e) {
            throw new ToJsonException(TO_JSON_MSG, e);
        }
        catch (IOException e) {
            throw new ToJsonException(TO_JSON_MSG, e);
        }
        return out;
    }

    protected void handleJsonParseException(JsonParseException jpe) throws DuplicateKeyException, InvalidPayloadException {
        Optional<String> duplicateKey = this.getJsonParseExceptionDuplicateKey(jpe);
        if (duplicateKey.isPresent()) {
            String msg = String.format(DUPLICATE_KEY_MSG, duplicateKey.get());
            throw new DuplicateKeyException(msg, jpe, duplicateKey.get());
        }
        throw new InvalidPayloadException(INVALID_PAYLOAD_MSG, jpe);
    }

    protected Optional<String> getJsonParseExceptionDuplicateKey(JsonParseException e) {
        Optional<String> key = Optional.empty();
        Matcher m = DUPLICATE_KEY_PATTERN.matcher(e.getOriginalMessage());
        if (m.matches()) {
            key = Optional.of(m.group(DUPLICATE_NAME));
        }
        return key;
    }
}

