package org.rootservices.otter.router.entity;

import org.rootservices.otter.controller.Resource;
import org.rootservices.otter.controller.entity.DefaultSession;
import org.rootservices.otter.controller.entity.DefaultUser;
import org.rootservices.otter.router.entity.between.Between;

import java.util.List;

public class Route<S extends DefaultSession, U extends DefaultUser> {
    private Resource<S, U> resource;
    private List<Between<S, U>> before;
    private List<Between<S, U>> after;

    public Route(Resource<S, U> resource, List<Between<S, U>> before, List<Between<S, U>> after) {
        this.resource = resource;
        this.before = before;
        this.after = after;
    }

    public Resource<S, U> getResource() {
        return resource;
    }

    public void setResource(Resource<S, U> resource) {
        this.resource = resource;
    }

    public List<Between<S, U>> getBefore() {
        return before;
    }

    public void setBefore(List<Between<S, U>> before) {
        this.before = before;
    }

    public List<Between<S, U>> getAfter() {
        return after;
    }

    public void setAfter(List<Between<S, U>> after) {
        this.after = after;
    }
}
