/*
 * Decompiled with CFR 0.152.
 */
package org.rsmod.pathfinder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.rsmod.pathfinder.Direction;
import org.rsmod.pathfinder.East;
import org.rsmod.pathfinder.North;
import org.rsmod.pathfinder.NorthEast;
import org.rsmod.pathfinder.NorthWest;
import org.rsmod.pathfinder.Route;
import org.rsmod.pathfinder.RouteCoordinates;
import org.rsmod.pathfinder.South;
import org.rsmod.pathfinder.SouthEast;
import org.rsmod.pathfinder.SouthWest;
import org.rsmod.pathfinder.West;
import org.rsmod.pathfinder.bound.RectangularBoundaryKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0003J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u001d\u0010\u0014\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0082\nJ,\u0010\u0017\u001a\u00020\u0018*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J$\u0010\u0019\u001a\u00020\u0018*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J$\u0010\u001a\u001a\u00020\u0018*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J,\u0010\u001b\u001a\u00020\u0018*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J%\u0010\u001c\u001a\u00020\u001d*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0082\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/rsmod/pathfinder/DumbPathFinder;", "", "searchMapSize", "", "(I)V", "getSearchMapSize", "()I", "findPath", "Lorg/rsmod/pathfinder/Route;", "clipFlags", "", "srcX", "srcY", "destX", "destY", "srcSize", "destWidth", "destHeight", "getDirection", "Lorg/rsmod/pathfinder/Direction;", "get", "x", "y", "isBlocked", "", "isBlocked1", "isBlocked2", "isBlockedN", "set", "", "value", "pathfinder"})
public final class DumbPathFinder {
    private final int searchMapSize;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Route findPath(@NotNull int[] clipFlags, int srcX, int srcY, int destX, int destY, int srcSize, int destWidth, int destHeight) {
        Intrinsics.checkNotNullParameter((Object)clipFlags, (String)"clipFlags");
        int baseX = srcX - this.searchMapSize / 2;
        int baseY = srcY - this.searchMapSize / 2;
        int localSrcX = srcX - baseX;
        int localSrcY = srcY - baseY;
        int localDestX = destX - baseX;
        int localDestY = destY - baseY;
        int x = localSrcX;
        int y = localSrcY;
        boolean bl = false;
        List coords = new ArrayList();
        boolean success = false;
        int n = 0;
        int n2 = this.searchMapSize * this.searchMapSize;
        while (n < n2) {
            void i;
            Direction dir;
            if (RectangularBoundaryKt.reachRectangle(clipFlags, this.searchMapSize, 0, srcX, srcY, localDestX, localDestY, srcSize, destWidth, destHeight)) {
                success = true;
                break;
            }
            int startX = x;
            int startY = y;
            if (this.getDirection(x, y, localDestX, localDestY) == null) {
                break;
            }
            boolean blocked = this.isBlocked(dir, clipFlags, x, y, srcSize);
            if (Intrinsics.areEqual((Object)dir, (Object)South.INSTANCE) && !blocked) {
                --y;
            } else if (Intrinsics.areEqual((Object)dir, (Object)North.INSTANCE) && !blocked) {
                ++y;
            } else if (Intrinsics.areEqual((Object)dir, (Object)West.INSTANCE) && !blocked) {
                --x;
            } else if (Intrinsics.areEqual((Object)dir, (Object)East.INSTANCE) && !blocked) {
                ++x;
            } else if (Intrinsics.areEqual((Object)dir, (Object)SouthWest.INSTANCE)) {
                if (blocked) {
                    if (!this.isBlocked(South.INSTANCE, clipFlags, x, y, srcSize)) {
                        --y;
                    } else if (!this.isBlocked(West.INSTANCE, clipFlags, x, y, srcSize)) {
                        --x;
                    }
                } else {
                    --x;
                    --y;
                }
            } else if (Intrinsics.areEqual((Object)dir, (Object)NorthWest.INSTANCE)) {
                if (blocked) {
                    if (!this.isBlocked(North.INSTANCE, clipFlags, x, y, srcSize)) {
                        ++y;
                    } else if (!this.isBlocked(West.INSTANCE, clipFlags, x, y, srcSize)) {
                        --x;
                    }
                } else {
                    --x;
                    ++y;
                }
            } else if (Intrinsics.areEqual((Object)dir, (Object)SouthEast.INSTANCE)) {
                if (blocked) {
                    if (!this.isBlocked(South.INSTANCE, clipFlags, x, y, srcSize)) {
                        --y;
                    } else if (!this.isBlocked(East.INSTANCE, clipFlags, x, y, srcSize)) {
                        ++x;
                    }
                } else {
                    ++x;
                    --y;
                }
            } else if (Intrinsics.areEqual((Object)dir, (Object)NorthEast.INSTANCE)) {
                if (blocked) {
                    if (!this.isBlocked(North.INSTANCE, clipFlags, x, y, srcSize)) {
                        ++y;
                    } else if (!this.isBlocked(East.INSTANCE, clipFlags, x, y, srcSize)) {
                        ++x;
                    }
                } else {
                    ++x;
                    ++y;
                }
            }
            if (startX == x && startY == y) break;
            coords.add(RouteCoordinates.box-impl(RouteCoordinates.constructor-impl(baseX + x, baseY + y)));
            ++i;
        }
        return new Route(coords, false, success);
    }

    public static /* synthetic */ Route findPath$default(DumbPathFinder dumbPathFinder, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if ((n8 & 0x20) != 0) {
            n5 = 1;
        }
        if ((n8 & 0x40) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x80) != 0) {
            n7 = 0;
        }
        return dumbPathFinder.findPath(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    private final boolean isBlocked(Direction $this$isBlocked, int[] clipFlags, int x, int y, int srcSize) {
        boolean bl;
        switch (srcSize) {
            case 1: {
                bl = this.isBlocked1($this$isBlocked, clipFlags, x, y);
                break;
            }
            case 2: {
                bl = this.isBlocked2($this$isBlocked, clipFlags, x, y);
                break;
            }
            default: {
                bl = this.isBlockedN($this$isBlocked, clipFlags, x, y, srcSize);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBlocked1(Direction $this$isBlocked1, int[] clipFlags, int x, int y) {
        int x$iv;
        Direction direction = $this$isBlocked1;
        if (Intrinsics.areEqual((Object)direction, (Object)South.INSTANCE)) {
            void $this$get$iv;
            void this_$iv;
            int[] nArray = clipFlags;
            DumbPathFinder dumbPathFinder = this;
            int y$iv = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv] & 0x12C0102) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)North.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv = y + 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv] & 0x12C0120) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)West.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv2 = x - 1;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv.getSearchMapSize() + x$iv2;
            if (($this$get$iv[index$iv] & 0x12C0108) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)East.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv3 = x + 1;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv.getSearchMapSize() + x$iv3;
            if (($this$get$iv[index$iv] & 0x12C0180) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthWest.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv3 = x - 1;
            int y$iv = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv3;
            if (($this$get$iv[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv3 = x - 1;
            boolean $i$f$get2 = false;
            int index$iv2 = y * this_$iv.getSearchMapSize() + x$iv3;
            if (($this$get$iv[index$iv2] & 0x12C0108) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            int y$iv2 = y - 1;
            $i$f$get2 = false;
            index$iv2 = y$iv2 * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv2] & 0x12C0102) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)NorthWest.INSTANCE)) {
            int x$iv4;
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv2 = x - 1;
            int y$iv = y + 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv4;
            if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv4 = x - 1;
            boolean $i$f$get3 = false;
            int index$iv3 = y * this_$iv.getSearchMapSize() + x$iv4;
            if (($this$get$iv[index$iv3] & 0x12C0108) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            y$iv2 = y + 1;
            $i$f$get3 = false;
            index$iv3 = y$iv2 * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv3] & 0x12C0120) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthEast.INSTANCE)) {
            int x$iv5;
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv = x + 1;
            int y$iv3 = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv3 * this_$iv.getSearchMapSize() + x$iv5;
            if (($this$get$iv[index$iv] & 0x12C0183) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv5 = x + 1;
            boolean $i$f$get4 = false;
            int index$iv4 = y * this_$iv.getSearchMapSize() + x$iv5;
            if (($this$get$iv[index$iv4] & 0x12C0180) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            y$iv = y - 1;
            $i$f$get4 = false;
            index$iv4 = y$iv * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv4] & 0x12C0102) == 0) return false;
            return true;
        }
        if (!Intrinsics.areEqual((Object)direction, (Object)NorthEast.INSTANCE)) throw new NoWhenBranchMatchedException();
        int[] $this$get$iv = clipFlags;
        DumbPathFinder this_$iv = this;
        int y$iv = x + 1;
        int y$iv4 = y + 1;
        boolean $i$f$get = false;
        int index$iv = y$iv4 * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C01E0) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        x$iv = x + 1;
        boolean $i$f$get5 = false;
        int index$iv5 = y * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv5] & 0x12C0180) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        y$iv = y + 1;
        $i$f$get5 = false;
        index$iv5 = y$iv * this_$iv.getSearchMapSize() + x;
        if (($this$get$iv[index$iv5] & 0x12C0120) == 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBlocked2(Direction $this$isBlocked2, int[] clipFlags, int x, int y) {
        Direction direction = $this$isBlocked2;
        if (Intrinsics.areEqual((Object)direction, (Object)South.INSTANCE)) {
            void x$iv;
            int[] $this$get$iv;
            DumbPathFinder this_$iv;
            int[] nArray = clipFlags;
            DumbPathFinder dumbPathFinder = this;
            int y$iv = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            y$iv = x + 1;
            int y$iv2 = y - 1;
            boolean $i$f$get2 = false;
            int index$iv2 = y$iv2 * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv2] & 0x12C0183) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)North.INSTANCE)) {
            void x$iv;
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv = y + 2;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            y$iv = x + 1;
            int y$iv3 = y + 2;
            boolean $i$f$get3 = false;
            int index$iv3 = y$iv3 * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv3] & 0x12C01E0) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)West.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv = x - 1;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x - 1;
            int y$iv = y + 1;
            boolean $i$f$get4 = false;
            int index$iv4 = y$iv * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv4] & 0x12C0138) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)East.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv = x + 2;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C0183) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x + 2;
            int y$iv = y + 1;
            boolean $i$f$get5 = false;
            int index$iv5 = y$iv * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv5] & 0x12C01E0) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthWest.INSTANCE)) {
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int x$iv = x - 1;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x - 1;
            int y$iv = y - 1;
            boolean $i$f$get6 = false;
            int index$iv6 = y$iv * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv6] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            int y$iv4 = y - 1;
            $i$f$get = false;
            index$iv = y$iv4 * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv] & 0x12C0183) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)NorthWest.INSTANCE)) {
            int x$iv;
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv4 = x - 1;
            int y$iv = y + 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x - 1;
            y$iv = y + 2;
            $i$f$get = false;
            index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            y$iv4 = y + 2;
            boolean $i$f$get7 = false;
            int index$iv7 = y$iv4 * this_$iv.getSearchMapSize() + x;
            if (($this$get$iv[index$iv7] & 0x12C01E0) == 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthEast.INSTANCE)) {
            int x$iv;
            int[] $this$get$iv = clipFlags;
            DumbPathFinder this_$iv = this;
            int y$iv = x + 1;
            int y$iv5 = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv5 * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x + 2;
            y$iv5 = y - 1;
            $i$f$get = false;
            index$iv = y$iv5 * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv] & 0x12C0183) != 0) return true;
            $this$get$iv = clipFlags;
            this_$iv = this;
            x$iv = x + 2;
            boolean $i$f$get8 = false;
            int index$iv8 = y * this_$iv.getSearchMapSize() + x$iv;
            if (($this$get$iv[index$iv8] & 0x12C01E0) == 0) return false;
            return true;
        }
        if (!Intrinsics.areEqual((Object)direction, (Object)NorthEast.INSTANCE)) throw new NoWhenBranchMatchedException();
        int[] $this$get$iv = clipFlags;
        DumbPathFinder this_$iv = this;
        int x$iv = x + 1;
        int y$iv = y + 2;
        boolean $i$f$get = false;
        int index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        x$iv = x + 2;
        y$iv = y + 2;
        $i$f$get = false;
        index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C01E0) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        x$iv = x + 2;
        y$iv = y + 1;
        $i$f$get = false;
        index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C0183) == 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBlockedN(Direction $this$isBlockedN, int[] clipFlags, int x, int y, int srcSize) {
        boolean bl;
        int[] $this$get$iv;
        int x$iv;
        DumbPathFinder this_$iv;
        Direction direction = $this$isBlockedN;
        if (Intrinsics.areEqual((Object)direction, (Object)South.INSTANCE)) {
            boolean bl2;
            void x$iv2;
            int[] $this$get$iv2;
            DumbPathFinder this_$iv2;
            int[] nArray = clipFlags;
            DumbPathFinder dumbPathFinder = this;
            int y$iv = y - 1;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv2.getSearchMapSize() + x;
            if (($this$get$iv2[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv2 = clipFlags;
            this_$iv2 = this;
            y$iv = x + srcSize - 1;
            int y$iv22 = y - 1;
            boolean $i$f$get2 = false;
            int index$iv2 = y$iv22 * this_$iv2.getSearchMapSize() + x$iv2;
            if (($this$get$iv2[index$iv2] & 0x12C0183) != 0) return true;
            int clipFlag = 19661199;
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator y$iv22 = $this$any$iv.iterator();
            do {
                void $this$get$iv3;
                void x$iv3;
                void this_$iv3;
                int element$iv;
                if (!y$iv22.hasNext()) return false;
                int it = element$iv = ((IntIterator)y$iv22).nextInt();
                boolean bl3 = false;
                int[] nArray2 = clipFlags;
                DumbPathFinder dumbPathFinder2 = this;
                int n = x + it;
                int y$iv3 = y;
                boolean $i$f$get3 = false;
                int index$iv3 = y$iv3 * this_$iv3.getSearchMapSize() + x$iv3;
                if (($this$get$iv3[index$iv3] & clipFlag) != 0) {
                    return true;
                }
                bl2 = false;
            } while (!bl2);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)North.INSTANCE)) {
            boolean bl4;
            void x$iv4;
            int[] $this$get$iv4;
            DumbPathFinder this_$iv4;
            Object $this$any$iv = clipFlags;
            DumbPathFinder clipFlag = this;
            int y$iv = y + srcSize;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv4.getSearchMapSize() + x;
            if (($this$get$iv4[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv4 = clipFlags;
            this_$iv4 = this;
            y$iv = x + srcSize - 1;
            int y$iv32 = y + srcSize;
            boolean $i$f$get4 = false;
            int index$iv4 = y$iv32 * this_$iv4.getSearchMapSize() + x$iv4;
            if (($this$get$iv4[index$iv4] & 0x12C01E0) != 0) return true;
            int clipFlag3 = 19661304;
            $this$any$iv = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator y$iv32 = $this$any$iv.iterator();
            do {
                int element$iv;
                if (!y$iv32.hasNext()) return false;
                int it = element$iv = ((IntIterator)y$iv32).nextInt();
                boolean bl5 = false;
                int[] $this$get$iv3 = clipFlags;
                DumbPathFinder this_$iv3 = this;
                int x$iv3 = x + it;
                int y$iv4 = y;
                boolean $i$f$get5 = false;
                int index$iv5 = y$iv4 * this_$iv3.getSearchMapSize() + x$iv3;
                if (($this$get$iv3[index$iv5] & clipFlag3) != 0) {
                    return true;
                }
                bl4 = false;
            } while (!bl4);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)West.INSTANCE)) {
            boolean bl6;
            int[] $this$get$iv5;
            DumbPathFinder this_$iv5;
            Object $this$any$iv = clipFlags;
            DumbPathFinder clipFlag3 = this;
            int x$iv5 = x - 1;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv5.getSearchMapSize() + x$iv5;
            if (($this$get$iv5[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv5 = clipFlags;
            this_$iv5 = this;
            x$iv5 = x - 1;
            int y$iv42 = y + srcSize - 1;
            boolean $i$f$get6 = false;
            int index$iv6 = y$iv42 * this_$iv5.getSearchMapSize() + x$iv5;
            if (($this$get$iv5[index$iv6] & 0x12C0138) != 0) return true;
            int clipFlag4 = 19661118;
            $this$any$iv = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator y$iv42 = $this$any$iv.iterator();
            do {
                int element$iv;
                if (!y$iv42.hasNext()) return false;
                int it = element$iv = ((IntIterator)y$iv42).nextInt();
                boolean bl7 = false;
                int[] $this$get$iv6 = clipFlags;
                DumbPathFinder this_$iv6 = this;
                int x$iv6 = x + it;
                int y$iv = y;
                boolean $i$f$get7 = false;
                int index$iv7 = y$iv * this_$iv6.getSearchMapSize() + x$iv6;
                if (($this$get$iv6[index$iv7] & clipFlag4) != 0) {
                    return true;
                }
                bl6 = false;
            } while (!bl6);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)East.INSTANCE)) {
            boolean bl8;
            int[] $this$get$iv7;
            DumbPathFinder this_$iv7;
            Object $this$any$iv = clipFlags;
            DumbPathFinder clipFlag4 = this;
            int x$iv7 = x + srcSize;
            boolean $i$f$get = false;
            int index$iv = y * this_$iv7.getSearchMapSize() + x$iv7;
            if (($this$get$iv7[index$iv] & 0x12C0183) != 0) return true;
            $this$get$iv7 = clipFlags;
            this_$iv7 = this;
            x$iv7 = x + srcSize;
            int y$iv52 = y + srcSize - 1;
            boolean $i$f$get8 = false;
            int index$iv8 = y$iv52 * this_$iv7.getSearchMapSize() + x$iv7;
            if (($this$get$iv7[index$iv8] & 0x12C01E0) != 0) return true;
            int clipFlag5 = 19661283;
            $this$any$iv = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator y$iv52 = $this$any$iv.iterator();
            do {
                int element$iv;
                if (!y$iv52.hasNext()) return false;
                int it = element$iv = ((IntIterator)y$iv52).nextInt();
                boolean bl9 = false;
                int[] $this$get$iv8 = clipFlags;
                DumbPathFinder this_$iv8 = this;
                int x$iv8 = x + it;
                int y$iv5 = y;
                boolean $i$f$get9 = false;
                int index$iv9 = y$iv5 * this_$iv8.getSearchMapSize() + x$iv8;
                if (($this$get$iv8[index$iv9] & clipFlag5) != 0) {
                    return true;
                }
                bl8 = false;
            } while (!bl8);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthWest.INSTANCE)) {
            boolean bl10;
            int[] $this$get$iv9;
            int x$iv9;
            DumbPathFinder this_$iv9;
            int[] $this$any$iv = clipFlags;
            DumbPathFinder clipFlag5 = this;
            int $i$f$any = x - 1;
            int y$iv = y + srcSize - 2;
            boolean $i$f$get = false;
            int index$iv = y$iv * this_$iv9.getSearchMapSize() + x$iv9;
            if (($this$get$iv9[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv9 = clipFlags;
            this_$iv9 = this;
            x$iv9 = x - 1;
            y$iv = y - 1;
            $i$f$get = false;
            index$iv = y$iv * this_$iv9.getSearchMapSize() + x$iv9;
            if (($this$get$iv9[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv9 = clipFlags;
            this_$iv9 = this;
            x$iv9 = x + srcSize - 2;
            y$iv = y - 1;
            $i$f$get = false;
            index$iv = y$iv * this_$iv9.getSearchMapSize() + x$iv9;
            if (($this$get$iv9[index$iv] & 0x12C0183) != 0) return true;
            int clipFlag1 = 19661304;
            int clipFlag2 = 19661199;
            Iterable $this$any$iv2 = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                return false;
            }
            Iterator $i$f$get2 = $this$any$iv2.iterator();
            do {
                int[] $this$get$iv10;
                int x$iv10;
                DumbPathFinder this_$iv10;
                int element$iv;
                if (!$i$f$get2.hasNext()) return false;
                int it = element$iv = ((IntIterator)$i$f$get2).nextInt();
                boolean bl11 = false;
                int[] this_$iv11 = clipFlags;
                DumbPathFinder x$iv11 = this;
                int y$iv5 = x - 1;
                int y$iv6 = y + it - 1;
                boolean $i$f$get10 = false;
                int index$iv10 = y$iv6 * this_$iv10.getSearchMapSize() + x$iv10;
                if (($this$get$iv10[index$iv10] & clipFlag1) != 0) return true;
                $this$get$iv10 = clipFlags;
                this_$iv10 = this;
                x$iv10 = x + it - 1;
                y$iv6 = y - 1;
                $i$f$get10 = false;
                index$iv10 = y$iv6 * this_$iv10.getSearchMapSize() + x$iv10;
                if (($this$get$iv10[index$iv10] & clipFlag2) != 0) {
                    return true;
                }
                bl10 = false;
            } while (!bl10);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)NorthWest.INSTANCE)) {
            boolean bl12;
            int[] $this$get$iv11;
            int x$iv12;
            DumbPathFinder this_$iv12;
            int[] clipFlag2 = clipFlags;
            DumbPathFinder clipFlag1 = this;
            int $this$any$iv2 = x - 1;
            int y$iv = y + 1;
            $i$f$get = false;
            int index$iv = y$iv * this_$iv12.getSearchMapSize() + x$iv12;
            if (($this$get$iv11[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv11 = clipFlags;
            this_$iv12 = this;
            x$iv12 = x - 1;
            y$iv = y + srcSize;
            $i$f$get = false;
            index$iv = y$iv * this_$iv12.getSearchMapSize() + x$iv12;
            if (($this$get$iv11[index$iv] & 0x12C0138) != 0) return true;
            $this$get$iv11 = clipFlags;
            this_$iv12 = this;
            int y$iv7 = y + srcSize;
            boolean $i$f$get = false;
            int index$iv22 = y$iv7 * this_$iv12.getSearchMapSize() + x;
            if (($this$get$iv11[index$iv22] & 0x12C01E0) != 0) return true;
            int clipFlag6 = 19661118;
            int clipFlag7 = 19661304;
            Iterable $this$any$iv22 = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                return false;
            }
            Iterator index$iv22 = $this$any$iv22.iterator();
            do {
                int element$iv;
                if (!index$iv22.hasNext()) return false;
                int it = element$iv = ((IntIterator)index$iv22).nextInt();
                boolean bl13 = false;
                int[] $this$get$iv12 = clipFlags;
                DumbPathFinder this_$iv13 = this;
                int x$iv13 = x - 1;
                int y$iv8 = y + it - 1;
                boolean $i$f$get11 = false;
                int index$iv11 = y$iv8 * this_$iv13.getSearchMapSize() + x$iv13;
                if (($this$get$iv12[index$iv11] & clipFlag6) != 0) return true;
                $this$get$iv12 = clipFlags;
                this_$iv13 = this;
                x$iv13 = x + it - 1;
                y$iv8 = y + srcSize;
                $i$f$get11 = false;
                index$iv11 = y$iv8 * this_$iv13.getSearchMapSize() + x$iv13;
                if (($this$get$iv12[index$iv11] & clipFlag7) != 0) {
                    return true;
                }
                bl12 = false;
            } while (!bl12);
            return true;
        }
        if (Intrinsics.areEqual((Object)direction, (Object)SouthEast.INSTANCE)) {
            boolean bl14;
            int[] $this$get$iv13;
            int x$iv14;
            DumbPathFinder this_$iv14;
            int[] clipFlag7 = clipFlags;
            DumbPathFinder clipFlag6 = this;
            int $this$any$iv22 = x + 1;
            int y$iv = y - 1;
            $i$f$get = false;
            int index$iv = y$iv * this_$iv14.getSearchMapSize() + x$iv14;
            if (($this$get$iv13[index$iv] & 0x12C010E) != 0) return true;
            $this$get$iv13 = clipFlags;
            this_$iv14 = this;
            x$iv14 = x + srcSize;
            y$iv = y - 1;
            $i$f$get = false;
            index$iv = y$iv * this_$iv14.getSearchMapSize() + x$iv14;
            if (($this$get$iv13[index$iv] & 0x12C0183) != 0) return true;
            $this$get$iv13 = clipFlags;
            this_$iv14 = this;
            x$iv14 = x + srcSize;
            y$iv = y + srcSize - 2;
            $i$f$get = false;
            index$iv = y$iv * this_$iv14.getSearchMapSize() + x$iv14;
            if (($this$get$iv13[index$iv] & 0x12C01E0) != 0) return true;
            int clipFlag8 = 19661283;
            int clipFlag9 = 19661199;
            Iterable $this$any$iv3 = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
            boolean $i$f$any = false;
            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                return false;
            }
            Iterator $i$f$get3 = $this$any$iv3.iterator();
            do {
                int element$iv;
                if (!$i$f$get3.hasNext()) return false;
                int it = element$iv = ((IntIterator)$i$f$get3).nextInt();
                boolean bl15 = false;
                int[] $this$get$iv14 = clipFlags;
                DumbPathFinder this_$iv15 = this;
                int x$iv15 = x + srcSize;
                int y$iv9 = y + it - 1;
                boolean $i$f$get = false;
                int index$iv12 = y$iv9 * this_$iv15.getSearchMapSize() + x$iv15;
                if (($this$get$iv14[index$iv12] & clipFlag8) != 0) return true;
                $this$get$iv14 = clipFlags;
                this_$iv15 = this;
                x$iv15 = x + it + 1;
                y$iv9 = y - 1;
                $i$f$get = false;
                index$iv12 = y$iv9 * this_$iv15.getSearchMapSize() + x$iv15;
                if (($this$get$iv14[index$iv12] & clipFlag9) != 0) {
                    return true;
                }
                bl14 = false;
            } while (!bl14);
            return true;
        }
        if (!Intrinsics.areEqual((Object)direction, (Object)NorthEast.INSTANCE)) throw new NoWhenBranchMatchedException();
        int[] clipFlag9 = clipFlags;
        DumbPathFinder clipFlag8 = this;
        int $this$any$iv3 = x + 1;
        int y$iv = y + srcSize;
        $i$f$get = false;
        int index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C0138) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        x$iv = x + srcSize;
        y$iv = y + srcSize;
        $i$f$get = false;
        index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C01E0) != 0) return true;
        $this$get$iv = clipFlags;
        this_$iv = this;
        x$iv = x + srcSize;
        y$iv = y + 1;
        $i$f$get = false;
        index$iv = y$iv * this_$iv.getSearchMapSize() + x$iv;
        if (($this$get$iv[index$iv] & 0x12C0183) != 0) return true;
        int clipFlag1 = 19661304;
        int clipFlag2 = 19661283;
        Iterable $this$any$iv = (Iterable)RangesKt.until((int)1, (int)(srcSize - 1));
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            int element$iv;
            if (!iterator.hasNext()) return false;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl16 = false;
            int[] $this$get$iv15 = clipFlags;
            DumbPathFinder this_$iv16 = this;
            int x$iv16 = x + it + 1;
            int y$iv10 = y + srcSize;
            boolean $i$f$get = false;
            int index$iv13 = y$iv10 * this_$iv16.getSearchMapSize() + x$iv16;
            if (($this$get$iv15[index$iv13] & clipFlag1) != 0) return true;
            $this$get$iv15 = clipFlags;
            this_$iv16 = this;
            x$iv16 = x + srcSize;
            y$iv10 = y + it + 1;
            $i$f$get = false;
            index$iv13 = y$iv10 * this_$iv16.getSearchMapSize() + x$iv16;
            if (($this$get$iv15[index$iv13] & clipFlag2) != 0) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Direction getDirection(int srcX, int srcY, int destX, int destY) {
        if (srcX == destX) {
            if (srcY > destY) {
                return South.INSTANCE;
            }
            if (srcY < destY) {
                return North.INSTANCE;
            }
        } else {
            return srcY == destY ? (srcX > destX ? (Direction)West.INSTANCE : (Direction)East.INSTANCE) : (srcX < destX && srcY < destY ? (Direction)NorthEast.INSTANCE : (srcX < destX ? (Direction)SouthEast.INSTANCE : (srcY < destY ? (Direction)NorthWest.INSTANCE : (Direction)SouthWest.INSTANCE)));
        }
        return null;
    }

    private final int get(int[] $this$get, int x, int y) {
        int $i$f$get = 0;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        int index = y * this.getSearchMapSize() + x;
        return $this$get[index];
    }

    private final void set(int[] $this$set, int x, int y, int value) {
        int $i$f$set = 0;
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"$this$set");
        int index = y * this.getSearchMapSize() + x;
        $this$set[index] = value;
    }

    public final int getSearchMapSize() {
        return this.searchMapSize;
    }

    public DumbPathFinder(int searchMapSize) {
        this.searchMapSize = searchMapSize;
    }

    public /* synthetic */ DumbPathFinder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        this(n);
    }

    public DumbPathFinder() {
        this(0, 1, null);
    }
}

