/*
 * Decompiled with CFR 0.152.
 */
package org.rsmod.pathfinder;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rsmod.pathfinder.Route;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002JL\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0003JL\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0003J\u001d\u0010\u0018\u001a\u00020\u0003*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0082\nJ$\u0010\u001b\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/rsmod/pathfinder/ProjectileValidator;", "", "searchMapSize", "", "(I)V", "getSearchMapSize", "()I", "coordinate", "a", "b", "size", "isValid", "", "flags", "", "srcX", "srcY", "destX", "destY", "srcSize", "destWidth", "destHeight", "rayCast", "Lorg/rsmod/pathfinder/Route;", "get", "x", "y", "isFlagged", "Companion", "pathfinder"})
public final class ProjectileValidator {
    private final int searchMapSize;
    private static final int BLOCKED_NORTH = 132096;
    private static final int BLOCKED_EAST = 135168;
    private static final int BLOCKED_SOUTH = 147456;
    private static final int BLOCKED_WEST = 196608;
    private static final int SCALE = 16;
    private static final int HALF_TILE;
    private static final Companion Companion;

    public final boolean isValid(@NotNull int[] flags, int srcX, int srcY, int destX, int destY, int srcSize, int destWidth, int destHeight) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Route route = this.rayCast(flags, srcX, srcY, destX, destY, srcSize, destWidth, destHeight);
        return route.getSuccess();
    }

    public static /* synthetic */ boolean isValid$default(ProjectileValidator projectileValidator, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if ((n8 & 0x20) != 0) {
            n5 = 1;
        }
        if ((n8 & 0x40) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x80) != 0) {
            n7 = 0;
        }
        return projectileValidator.isValid(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    @NotNull
    public final Route rayCast(@NotNull int[] flags, int srcX, int srcY, int destX, int destY, int srcSize, int destWidth, int destHeight) {
        int offsetX;
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        int halfMap = this.searchMapSize / 2;
        int baseX = srcX - halfMap;
        int baseY = srcY - halfMap;
        int localSrcX = srcX - baseX;
        int localSrcY = srcY - baseY;
        int localDestX = destX - baseX;
        int localDestY = destY - baseY;
        int startX = this.coordinate(localSrcX, localDestX, srcSize);
        int startY = this.coordinate(localSrcY, localDestY, srcSize);
        int endX = this.coordinate(localDestX, localSrcX, destWidth);
        int endY = this.coordinate(localDestY, localSrcY, destHeight);
        int deltaX = endX - startX;
        int deltaY = endY - startY;
        boolean travelEast = deltaX >= 0;
        boolean travelNorth = deltaY >= 0;
        int xFlags = travelEast ? 196608 : 135168;
        int yFlags = travelNorth ? 147456 : 132096;
        boolean bl = false;
        List coords = new ArrayList();
        bl = false;
        bl = false;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            offsetX = travelEast ? 1 : -1;
            int offsetY = travelNorth ? 0 : -1;
            int scaledY = ProjectileValidator.Companion.scaleUp(startY) + HALF_TILE + offsetY;
            boolean bl2 = false;
            int tangent = ProjectileValidator.Companion.scaleUp(deltaY) / Math.abs(deltaX);
            int currX = startX;
            while (currX != endX) {
                int currY = ProjectileValidator.Companion.scaleDown(scaledY);
                if (this.isFlagged(flags, currX += offsetX, currY, xFlags)) {
                    return new Route(coords, false, false);
                }
                int nextY = ProjectileValidator.Companion.scaleDown(scaledY += tangent);
                if (nextY == currY || !this.isFlagged(flags, currX, nextY, yFlags)) continue;
                return new Route(coords, false, false);
            }
        } else {
            offsetX = travelEast ? 0 : -1;
            int offsetY = travelNorth ? 1 : -1;
            int scaledX = ProjectileValidator.Companion.scaleUp(startX) + HALF_TILE + offsetX;
            boolean currX = false;
            int tangent = ProjectileValidator.Companion.scaleUp(deltaX) / Math.abs(deltaY);
            int currY = startY;
            while (currY != endY) {
                int currX2 = ProjectileValidator.Companion.scaleDown(scaledX);
                if (this.isFlagged(flags, currX2, currY += offsetY, yFlags)) {
                    return new Route(coords, false, false);
                }
                int nextX = ProjectileValidator.Companion.scaleDown(scaledX += tangent);
                if (nextX == currX2 || !this.isFlagged(flags, nextX, currY, xFlags)) continue;
                return new Route(coords, false, false);
            }
        }
        return new Route(coords, false, true);
    }

    public static /* synthetic */ Route rayCast$default(ProjectileValidator projectileValidator, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if ((n8 & 0x20) != 0) {
            n5 = 1;
        }
        if ((n8 & 0x40) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x80) != 0) {
            n7 = 0;
        }
        return projectileValidator.rayCast(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    private final int coordinate(int a, int b, int size) {
        return a >= b ? a : (a + size - 1 <= b ? a + size - 1 : b);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFlagged(int[] $this$isFlagged, int x, int y, int flags) {
        void $this$get$iv;
        int[] nArray = $this$isFlagged;
        ProjectileValidator this_$iv = this;
        boolean $i$f$get = false;
        int index$iv = y * this_$iv.getSearchMapSize() + x;
        return ($this$get$iv[index$iv] & flags) != 0;
    }

    private final int get(int[] $this$get, int x, int y) {
        int $i$f$get = 0;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        int index = y * this.getSearchMapSize() + x;
        return $this$get[index];
    }

    public final int getSearchMapSize() {
        return this.searchMapSize;
    }

    public ProjectileValidator(int searchMapSize) {
        this.searchMapSize = searchMapSize;
    }

    public /* synthetic */ ProjectileValidator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        this(n);
    }

    public ProjectileValidator() {
        this(0, 1, null);
    }

    static {
        Companion = new Companion(null);
        HALF_TILE = ProjectileValidator.Companion.scaleUp(1) / 2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rsmod/pathfinder/ProjectileValidator$Companion;", "", "()V", "BLOCKED_EAST", "", "BLOCKED_NORTH", "BLOCKED_SOUTH", "BLOCKED_WEST", "HALF_TILE", "SCALE", "scaleDown", "tiles", "scaleUp", "pathfinder"})
    private static final class Companion {
        private final int scaleUp(int tiles) {
            return tiles << 16;
        }

        private final int scaleDown(int tiles) {
            return tiles >>> 16;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

