/*
 * Decompiled with CFR 0.152.
 */
package org.rsmod.pathfinder.reach;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rsmod.pathfinder.bound.RectangularBoundaryKt;
import org.rsmod.pathfinder.bound.WallBoundaryKt;
import org.rsmod.pathfinder.bound.WallDecorationBoundaryKt;
import org.rsmod.pathfinder.reach.ReachStrategy;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jh\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/rsmod/pathfinder/reach/DefaultReachStrategy;", "Lorg/rsmod/pathfinder/reach/ReachStrategy;", "()V", "exitStrategy", "", "getExitStrategy", "(I)I", "reached", "", "flags", "", "localSrcX", "localSrcY", "localDestX", "localDestY", "destWidth", "destHeight", "srcSize", "rotation", "shape", "accessBitMask", "searchMapSize", "pathfinder"})
public final class DefaultReachStrategy
implements ReachStrategy {
    public static final DefaultReachStrategy INSTANCE;

    @Override
    public boolean reached(@NotNull int[] flags, int localSrcX, int localSrcY, int localDestX, int localDestY, int destWidth, int destHeight, int srcSize, int rotation, int shape, int accessBitMask, int searchMapSize) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        if (localSrcX == localDestX && localSrcY == localDestY) {
            return true;
        }
        switch (this.getExitStrategy(shape)) {
            case 0: {
                bl = WallBoundaryKt.reachWall(flags, searchMapSize, localSrcX, localSrcY, localDestX, localDestY, srcSize, shape, rotation);
                break;
            }
            case 1: {
                bl = WallDecorationBoundaryKt.reachWallDeco(flags, searchMapSize, localSrcX, localSrcY, localDestX, localDestY, srcSize, shape, rotation);
                break;
            }
            case 2: {
                bl = RectangularBoundaryKt.reachRectangle(flags, searchMapSize, accessBitMask, localSrcX, localSrcY, localDestX, localDestY, srcSize, destWidth, destHeight);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getExitStrategy(int $this$exitStrategy) {
        if ($this$exitStrategy == -1) {
            return 3;
        }
        int n = $this$exitStrategy;
        if (0 <= n) {
            if (3 >= n) return 0;
        }
        if ($this$exitStrategy == 9) {
            return 0;
        }
        if ($this$exitStrategy < 9) {
            return 1;
        }
        n = $this$exitStrategy;
        if (10 <= n) {
            if (11 >= n) return 2;
        }
        if ($this$exitStrategy != 22) return 3;
        return 2;
    }

    private DefaultReachStrategy() {
    }

    static {
        DefaultReachStrategy defaultReachStrategy;
        INSTANCE = defaultReachStrategy = new DefaultReachStrategy();
    }
}

