/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.toolbelt.format.yaml.snakeyaml;

import java.util.Optional;
import java.util.function.Function;
import org.rundeck.toolbelt.BaseDataOutputFormatter;
import org.rundeck.toolbelt.Formatable;
import org.rundeck.toolbelt.OutputFormatter;
import org.rundeck.toolbelt.ToStringFormatter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlFormatter
extends BaseDataOutputFormatter {
    private final Yaml yaml;

    public YamlFormatter() {
        this((OutputFormatter)new ToStringFormatter());
    }

    public YamlFormatter(Representer representer, DumperOptions options) {
        this(new Yaml(representer, options), (OutputFormatter)new ToStringFormatter());
    }

    public YamlFormatter(Function<Object, Optional<Formatable>> dataFormatter, Yaml yaml) {
        super(dataFormatter);
        this.yaml = yaml;
    }

    public YamlFormatter(OutputFormatter base) {
        this(new Yaml(), base);
    }

    public YamlFormatter(OutputFormatter base, Function<Object, Optional<Formatable>> dataFormatter, Yaml yaml) {
        super(base, dataFormatter);
        this.yaml = yaml;
    }

    private YamlFormatter(Yaml yaml, OutputFormatter base) {
        super(base);
        this.yaml = yaml;
    }

    protected OutputFormatter withBase(Function<Object, Optional<Formatable>> dataFormatter, OutputFormatter base) {
        return new YamlFormatter(base, dataFormatter, this.yaml);
    }

    public YamlFormatter(OutputFormatter base, DumperOptions options) {
        super(base);
        this.yaml = new Yaml(options);
    }

    protected boolean canFormatObject(Object value) {
        return true;
    }

    protected String formatObject(Object o) {
        return this.yaml.dump(o);
    }
}

