/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rundeck.core.auth.AuthResources;
import org.rundeck.core.auth.access.AuthActions;
import org.rundeck.core.auth.access.AuthActionsUtil;
import org.rundeck.core.auth.access.NamedAuthDefinition;

public class RundeckAccess {

    public static final class Job
    implements NamedAuthDefinition {
        public static final String GROUP = "job";
        public static final String TYPE = "project.job";
        public static final String AUTH_APP_READ_OR_VIEW = "appReadOrView";
        public static final AuthActions APP_READ_OR_VIEW = AuthActionsUtil.or("read", "view").or(General.APP_ADMIN);
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "job";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put(Job.AUTH_APP_READ_OR_VIEW, APP_READ_OR_VIEW);
                    this.putAll(General.NAMED_AUTH_ACTIONS);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }

    public static final class Execution
    implements NamedAuthDefinition {
        public static final String GROUP = "execution";
        public static final String TYPE = "project.execution";
        public static final String AUTH_APP_READ_OR_VIEW = "readOrView";
        public static final AuthActions APP_READ_OR_VIEW = AuthActionsUtil.action("view").or("read").or(General.APP_ADMIN);
        public static final String AUTH_APP_KILL = "appKill";
        public static final AuthActions APP_KILL = AuthActionsUtil.or("kill", General.APP_ADMIN);
        public static final String AUTH_APP_KILLAS = "appKillAs";
        public static final AuthActions APP_KILLAS = AuthActionsUtil.or("killAs", General.APP_ADMIN);
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "execution";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put(Execution.AUTH_APP_READ_OR_VIEW, APP_READ_OR_VIEW);
                    this.put("appDelete", General.APP_DELETE);
                    this.put(Execution.AUTH_APP_KILL, APP_KILL);
                    this.put(Execution.AUTH_APP_KILLAS, APP_KILLAS);
                    this.putAll(General.NAMED_AUTH_ACTIONS);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }

    public static final class ProjectAcl
    implements NamedAuthDefinition {
        public static final String GROUP = "projectAcl";
        public static final String TYPE = "app.projectAcl";
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "projectAcl";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put("appCreate", General.APP_CREATE);
                    this.put("appRead", General.APP_READ);
                    this.put("appUpdate", General.APP_UPDATE);
                    this.put("appDelete", General.APP_DELETE);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }

    public static final class Adhoc
    implements NamedAuthDefinition {
        public static final String GROUP = "adhoc";
        public static final String TYPE = "project.adhoc";
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "adhoc";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put("appRead", General.APP_READ);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }

    public static final class ProjectType
    implements NamedAuthDefinition {
        public static final String GROUP = "projectType";
        public static final String TYPE = "project.resource";
        public static final Set<String> RESOURCE_TYPES;
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "projectType";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        public static String typeForKind(String kind) {
            return "project.resource." + kind;
        }

        public static String kindForTypeId(String type) {
            if (type.startsWith("project.resource.")) {
                return type.substring(TYPE.length() + 1);
            }
            return null;
        }

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put("appCreate", General.APP_CREATE);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
            RESOURCE_TYPES = Collections.unmodifiableSet(AuthResources.projectKinds);
        }
    }

    public static final class ApplicationType
    implements NamedAuthDefinition {
        public static final String GROUP = "appType";
        public static final String TYPE = "app.resource";
        public static final Set<String> RESOURCE_TYPES;
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "appType";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        public static String typeForKind(String kind) {
            return "app.resource." + kind;
        }

        public static String kindForTypeId(String type) {
            if (type.startsWith("app.resource.")) {
                return type.substring(TYPE.length() + 1);
            }
            return null;
        }

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.putAll(General.NAMED_AUTH_ACTIONS);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
            RESOURCE_TYPES = Collections.unmodifiableSet(AuthResources.appKinds);
        }
    }

    public static final class Project
    implements NamedAuthDefinition {
        public static final String GROUP = "project";
        public static final String TYPE = "app.project";
        public static final String AUTH_APP_CONFIGURE = "appConfigure";
        public static final AuthActions APP_CONFIGURE = AuthActionsUtil.action("configure").or(General.APP_ADMIN);
        public static final String AUTH_APP_DELETE_EXECUTION = "appDeleteExecution";
        public static final AuthActions APP_DELETE_EXECUTION = AuthActionsUtil.action("delete_execution").or(General.APP_ADMIN);
        public static final String AUTH_APP_EXPORT = "appExport";
        public static final AuthActions APP_EXPORT = AuthActionsUtil.action("export").or(General.APP_ADMIN);
        public static final String AUTH_APP_IMPORT = "appImport";
        public static final AuthActions APP_IMPORT = AuthActionsUtil.action("import").or(General.APP_ADMIN);
        public static final String AUTH_APP_PROMOTE = "appPromote";
        public static final AuthActions APP_PROMOTE = AuthActionsUtil.action("promote").or(General.APP_ADMIN);
        public static final String AUTH_APP_SCM_EXPORT = "appScmExport";
        public static final AuthActions APP_SCM_EXPORT = AuthActionsUtil.or("export").or("scm_export").or(General.APP_ADMIN);
        public static final String AUTH_APP_SCM_IMPORT = "appScmImport";
        public static final AuthActions APP_SCM_IMPORT = AuthActionsUtil.or("import").or("scm_import").or(General.APP_ADMIN);
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;
        final String groupName = "project";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put(Project.AUTH_APP_CONFIGURE, APP_CONFIGURE);
                    this.put(Project.AUTH_APP_DELETE_EXECUTION, APP_DELETE_EXECUTION);
                    this.put(Project.AUTH_APP_EXPORT, APP_EXPORT);
                    this.put(Project.AUTH_APP_IMPORT, APP_IMPORT);
                    this.put(Project.AUTH_APP_PROMOTE, APP_PROMOTE);
                    this.put(Project.AUTH_APP_SCM_EXPORT, APP_SCM_EXPORT);
                    this.put(Project.AUTH_APP_SCM_IMPORT, APP_SCM_IMPORT);
                    this.putAll(General.NAMED_AUTH_ACTIONS);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }

    public static final class System
    implements NamedAuthDefinition {
        public static final String GROUP = "system";
        public static final String TYPE = "app.system";
        public static final String AUTH_CONFIGURE = "configure";
        public static final AuthActions APP_CONFIGURE = AuthActionsUtil.action("configure").or(General.ALL_ADMIN);
        public static final String AUTH_OPS_ENABLE_EXECUTION = "opsEnableExecution";
        public static final AuthActions OPS_ENABLE_EXECUTION = AuthActionsUtil.action("enable_executions").or(General.OPS_ADMIN);
        public static final String AUTH_OPS_DISABLE_EXECUTION = "opsDisableExecution";
        public static final AuthActions OPS_DISABLE_EXECUTION = AuthActionsUtil.action("disable_executions").or(General.OPS_ADMIN);
        public static final String AUTH_READ_OR_ANY_ADMIN = "readOrAnyAdmin";
        public static final AuthActions READ_OR_ANY_ADMIN = AuthActionsUtil.action("read").or(General.ALL_ADMIN);
        public static final String AUTH_READ_OR_OPS_ADMIN = "readOrOpsAdmin";
        public static final AuthActions READ_OR_OPS_ADMIN = AuthActionsUtil.action("read").or(General.OPS_ADMIN);
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(new HashMap<String, AuthActions>(){
            {
                this.put(System.AUTH_CONFIGURE, APP_CONFIGURE);
                this.put(System.AUTH_OPS_DISABLE_EXECUTION, OPS_DISABLE_EXECUTION);
                this.put(System.AUTH_OPS_ENABLE_EXECUTION, OPS_ENABLE_EXECUTION);
                this.put(System.AUTH_READ_OR_ANY_ADMIN, READ_OR_ANY_ADMIN);
                this.put(System.AUTH_READ_OR_OPS_ADMIN, READ_OR_OPS_ADMIN);
                this.putAll(General.NAMED_AUTH_ACTIONS);
            }
        });
        final String groupName = "system";
        final Map<String, AuthActions> definitions = NAMED_AUTH_ACTIONS;

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Map<String, AuthActions> getDefinitions() {
            return this.definitions;
        }
    }

    public static final class General {
        public static final String AUTH_ANY_ADMIN = "anyAdmin";
        public static final AuthActions ALL_ADMIN = AuthActionsUtil.or("admin", "app_admin", "ops_admin");
        public static final String AUTH_APP_ADMIN = "appAdmin";
        public static final AuthActions APP_ADMIN = AuthActionsUtil.or("admin", "app_admin");
        public static final String AUTH_OPS_ADMIN = "opsAdmin";
        public static final AuthActions OPS_ADMIN = AuthActionsUtil.or("admin", "ops_admin");
        public static final String AUTH_APP_CREATE = "appCreate";
        public static final AuthActions APP_CREATE = AuthActionsUtil.or("create", APP_ADMIN);
        public static final String AUTH_APP_READ = "appRead";
        public static final AuthActions APP_READ = AuthActionsUtil.or("read", APP_ADMIN);
        public static final String AUTH_APP_UPDATE = "appUpdate";
        public static final AuthActions APP_UPDATE = AuthActionsUtil.or("update", APP_ADMIN);
        public static final String AUTH_APP_DELETE = "appDelete";
        public static final AuthActions APP_DELETE = AuthActionsUtil.or("delete", APP_ADMIN);
        public static final Map<String, AuthActions> NAMED_AUTH_ACTIONS;

        static {
            HashMap<String, AuthActions> named = new HashMap<String, AuthActions>(){
                {
                    this.put(General.AUTH_ANY_ADMIN, ALL_ADMIN);
                    this.put(General.AUTH_APP_ADMIN, APP_ADMIN);
                    this.put(General.AUTH_OPS_ADMIN, OPS_ADMIN);
                    this.put(General.AUTH_APP_CREATE, APP_CREATE);
                    this.put(General.AUTH_APP_READ, APP_READ);
                    this.put(General.AUTH_APP_UPDATE, APP_UPDATE);
                    this.put(General.AUTH_APP_DELETE, APP_DELETE);
                }
            };
            NAMED_AUTH_ACTIONS = Collections.unmodifiableMap(named);
        }
    }
}

