/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.rundeck.core.auth.access.AuthActions;

public class AuthActionsUtil {
    private AuthActionsUtil() {
    }

    public static AuthActions action(String action) {
        return AuthActionsUtil.or(Collections.singletonList(action));
    }

    public static AuthActions or(AuthActions a, AuthActions b) {
        return AuthActionsUtil.or(AuthActionsUtil.append(a.getActions(), b.getActions()));
    }

    private static List<String> append(List<String> a, List<String> b) {
        ArrayList<String> newList = new ArrayList<String>(a);
        newList.addAll(b);
        return newList;
    }

    public static AuthActions or(String a, AuthActions actions) {
        return AuthActionsUtil.or(Collections.singletonList(a), actions);
    }

    public static AuthActions or(List<String> a, AuthActions actions) {
        if (AuthActionsUtil.nonEmpty(actions.getActions())) {
            return AuthActionsUtil.or(AuthActionsUtil.append(a, actions.getActions()));
        }
        throw new IllegalArgumentException("Cannot combine any and all access levels: " + String.valueOf(actions) + " and " + String.valueOf(a));
    }

    private static boolean nonEmpty(List<String> list) {
        return list != null && list.size() > 0;
    }

    public static AuthActions or(AuthActions a, List<String> actions) {
        return AuthActionsUtil.or(actions, a);
    }

    public static AuthActions or(String ... args) {
        return AuthActionsUtil.or(Arrays.asList(args));
    }

    public static AuthActions or(List<String> args) {
        return new AnyAuth(args);
    }

    public static AuthActions withDescription(AuthActions actions, String description) {
        return new AnyAuth(actions.getActions(), description);
    }

    public static class AnyAuth
    implements AuthActions {
        private final List<String> actions;
        private final String description;

        public AnyAuth(List<String> actions) {
            this(actions, null);
        }

        public AnyAuth(List<String> actions, String description) {
            if (null == actions || actions.size() < 1) {
                throw new IllegalArgumentException("anyActions cannot be empty");
            }
            this.actions = actions;
            this.description = description;
        }

        @Override
        public String getDescription() {
            if (null != this.description) {
                return this.description;
            }
            if (this.actions != null && this.actions.size() > 0) {
                return this.actions.get(0);
            }
            return "(unknown)";
        }

        public String toString() {
            return "AnyAccess{" + String.valueOf(this.getActions()) + (String)(this.description != null ? ": " + this.description : "") + "}";
        }

        @Override
        @Generated
        public List<String> getActions() {
            return this.actions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnyAuth)) {
                return false;
            }
            AnyAuth other = (AnyAuth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$actions = this.getActions();
            List<String> other$actions = other.getActions();
            return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AnyAuth;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            return result;
        }
    }
}

