/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.access;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthContextProcessor;
import com.dtolabs.rundeck.core.authorization.AuthResource;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import javax.security.auth.Subject;
import lombok.Generated;
import org.rundeck.core.auth.access.AuthActions;
import org.rundeck.core.auth.access.AuthorizingIdResource;
import org.rundeck.core.auth.access.BaseAuthorizingResource;
import org.rundeck.core.auth.access.NamedAuthProvider;
import org.rundeck.core.auth.access.NotFound;

public abstract class BaseAuthorizingIdResource<T, ID>
extends BaseAuthorizingResource<T>
implements AuthorizingIdResource<T, ID> {
    private final ID identifier;
    private UserAndRolesAuthContext loadedAuthContext = null;

    public BaseAuthorizingIdResource(AuthContextProcessor rundeckAuthContextProcessor, Subject subject, NamedAuthProvider namedAuthActions, ID identifier) {
        super(rundeckAuthContextProcessor, subject, namedAuthActions);
        this.identifier = identifier;
    }

    protected abstract String getProject();

    protected boolean isAuthContextWithProject() {
        return true;
    }

    @Override
    public UserAndRolesAuthContext getAuthContext() {
        return this.getAuthContext(this.getProject());
    }

    public UserAndRolesAuthContext getAuthContext(String project) {
        if (null == this.loadedAuthContext) {
            this.loadedAuthContext = this.isAuthContextWithProject() ? this.getRundeckAuthContextProcessor().getAuthContextForSubjectAndProject(this.getSubject(), project) : this.getRundeckAuthContextProcessor().getAuthContextForSubject(this.getSubject());
        }
        return this.loadedAuthContext;
    }

    @Override
    public boolean isAuthorized(AuthActions actions) throws NotFound {
        Object res = this.getResource();
        String projectLevel = this.getProject();
        AuthResource authResource = this.getAuthResource(res);
        if (projectLevel == null || authResource.getContext() == AuthResource.Context.System) {
            return super.isAuthorized(actions);
        }
        UserAndRolesAuthContext authContext = this.getAuthContext(projectLevel);
        return this.getRundeckAuthContextProcessor().authorizeProjectResourceAny((AuthContext)authContext, authResource.getResourceMap(), actions.getActions(), projectLevel);
    }

    @Override
    @Generated
    public ID getIdentifier() {
        return this.identifier;
    }
}

