/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.access;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthContextProcessor;
import com.dtolabs.rundeck.core.authorization.AuthResource;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import javax.security.auth.Subject;
import org.rundeck.core.auth.access.AuthActions;
import org.rundeck.core.auth.access.AuthorizingAccess;
import org.rundeck.core.auth.access.NamedAuthProvider;
import org.rundeck.core.auth.access.NotFound;
import org.rundeck.core.auth.access.UnauthorizedAccess;
import org.rundeck.core.auth.app.NamedAuthRequest;

public abstract class BaseAuthorizingAccess
implements AuthorizingAccess {
    private final AuthContextProcessor rundeckAuthContextProcessor;
    private final Subject subject;
    private final NamedAuthProvider namedAuthActions;
    private UserAndRolesAuthContext authContext = null;

    public BaseAuthorizingAccess(AuthContextProcessor rundeckAuthContextProcessor, Subject subject, NamedAuthProvider namedAuthActions) {
        this.rundeckAuthContextProcessor = rundeckAuthContextProcessor;
        this.subject = subject;
        this.namedAuthActions = namedAuthActions;
    }

    @Override
    public UserAndRolesAuthContext getAuthContext() {
        if (null == this.authContext) {
            this.authContext = this.getRundeckAuthContextProcessor().getAuthContextForSubject(this.getSubject());
        }
        return this.authContext;
    }

    @Override
    public void authorizeNamed(NamedAuthRequest namedAuthRequest) throws UnauthorizedAccess, NotFound {
        this.authorize(this.getNamedAuth(namedAuthRequest).withDescription(namedAuthRequest.getDescription()));
    }

    public AuthActions getNamedAuth(NamedAuthRequest namedAuthRequest) {
        return this.namedAuthActions.getNamedAuth(namedAuthRequest.getAuthGroup(), namedAuthRequest.getNamedAuth());
    }

    @Override
    public boolean isAuthorized(NamedAuthRequest namedAuthRequest) throws NotFound {
        return this.isAuthorized(this.getNamedAuth(namedAuthRequest).withDescription(namedAuthRequest.getDescription()));
    }

    @Override
    public void authorize(AuthActions actions) throws UnauthorizedAccess, NotFound {
        if (!this.isAuthorized(actions)) {
            throw new UnauthorizedAccess(actions.getDescription(), this.getResourceTypeName(), this.getResourceIdent());
        }
    }

    @Override
    public boolean isAuthorized(AuthActions actions) throws NotFound {
        AuthResource authResource = this.getAuthResource();
        if (authResource.getContext() != AuthResource.Context.System) {
            throw new IllegalStateException("Cannot authorize Project-level resource without a project name");
        }
        return this.getRundeckAuthContextProcessor().authorizeApplicationResourceAny((AuthContext)this.getAuthContext(), authResource.getResourceMap(), actions.getActions());
    }

    protected abstract AuthResource getAuthResource() throws NotFound;

    protected abstract String getResourceTypeName();

    protected abstract String getResourceIdent();

    public AuthContextProcessor getRundeckAuthContextProcessor() {
        return this.rundeckAuthContextProcessor;
    }

    public Subject getSubject() {
        return this.subject;
    }
}

