/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers.yaml.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ACLPolicyDoc {
    private Context context;
    private String description;
    private Map<String, List<TypeRule>> forSection;
    private By by;
    private NotBy notBy;
    private String id;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public By getBy() {
        return this.by;
    }

    public void setBy(By by) {
        this.by = by;
    }

    public NotBy getNotBy() {
        return this.notBy;
    }

    public void setNotBy(NotBy notBy) {
        this.notBy = notBy;
    }

    public Map<String, List<TypeRule>> getFor() {
        return this.forSection;
    }

    public void setFor(Map<String, List<TypeRule>> forSection) {
        this.forSection = forSection;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "Policy{context=" + this.context + ", description='" + this.description + "', for=" + this.forSection + ", by=" + this.by + ", notBy=" + this.notBy + ", id='" + this.id + "'}";
    }

    public static class NotBy {
        private Object username;
        private Object group;
        private Object urn;

        public Object getUsername() {
            return this.username;
        }

        public void setUsername(Object username) {
            this.username = username;
        }

        public Object getGroup() {
            return this.group;
        }

        public void setGroup(Object group) {
            this.group = group;
        }

        public Object getUrn() {
            return this.urn;
        }

        public void setUrn(Object urn) {
            this.urn = urn;
        }

        public String toString() {
            return "NotBy{username=" + this.username + ", group=" + this.group + ", urn=" + this.urn + "}";
        }
    }

    public static class By {
        private Object username;
        private Object group;
        private Object urn;

        public Object getUsername() {
            return this.username;
        }

        public void setUsername(Object username) {
            this.username = username;
        }

        public Object getGroup() {
            return this.group;
        }

        public void setGroup(Object group) {
            this.group = group;
        }

        public Object getUrn() {
            return this.urn;
        }

        public void setUrn(Object urn) {
            this.urn = urn;
        }

        public String toString() {
            return "By{username=" + this.username + ", group=" + this.group + ", urn=" + this.urn + "}";
        }
    }

    public static class TypeRule {
        private Map<String, Object> equals;
        private Map<String, Object> contains;
        private Map<String, Object> subset;
        private Map<String, Object> match;
        private Object allow;
        private Object deny;

        public Map<String, Object> getEquals() {
            return this.equals;
        }

        public void setEquals(Map<String, Object> equals) {
            this.equals = equals;
        }

        public Map<String, Object> getContains() {
            return this.contains;
        }

        public void setContains(Map<String, Object> contains) {
            this.contains = contains;
        }

        public Map<String, Object> getSubset() {
            return this.subset;
        }

        public void setSubset(Map<String, Object> subset) {
            this.subset = subset;
        }

        public Map<String, Object> getMatch() {
            return this.match;
        }

        public void setMatch(Map<String, Object> match) {
            this.match = match;
        }

        public Object getAllow() {
            return this.allow;
        }

        public void setAllow(Object allow) {
            this.allow = allow;
        }

        public Object getDeny() {
            return this.deny;
        }

        public void setDeny(Object deny) {
            this.deny = deny;
        }

        public Set<String> getAllowActions() {
            return this.getValue(this.allow);
        }

        private Set<String> getValue(Object ruleobj) {
            HashSet<String> actions = new HashSet<String>();
            if (ruleobj instanceof String) {
                String actionStr = (String)ruleobj;
                actions.add(actionStr);
            } else if (ruleobj instanceof List) {
                actions.addAll((List)ruleobj);
            } else {
                return null;
            }
            return actions;
        }

        boolean validRule(Object ruleobj) {
            return ruleobj instanceof String || ruleobj instanceof List;
        }

        public boolean validDeny() {
            return null == this.deny || this.validRule(this.deny);
        }

        public boolean validAllow() {
            return null == this.allow || this.validRule(this.allow);
        }

        public Set<String> getDenyActions() {
            return this.getValue(this.deny);
        }

        public String toString() {
            return "Rule{" + (String)(this.equals != null ? " equals=" + this.equals : "") + (String)(this.contains != null ? " contains=" + this.contains : "") + (String)(this.subset != null ? " subset=" + this.subset : "") + (String)(this.match != null ? " match=" + this.match : "") + (String)(this.allow != null ? " allow=" + this.allow : "") + (String)(this.deny != null ? " deny=" + this.deny : "") + "}";
        }

        public boolean hasresource() {
            return this.notEmpty(this.equals) || this.notEmpty(this.contains) || this.notEmpty(this.subset) || this.notEmpty(this.match);
        }

        public boolean isEmpty() {
            return !this.hasActions();
        }

        private boolean hasActions() {
            return this.notEmpty(this.getAllowActions()) || this.notEmpty(this.getDenyActions());
        }

        private boolean isEmpty(Map val) {
            return null != val && val.size() == 0;
        }

        private boolean notEmpty(Map val) {
            return null != val && val.size() > 0;
        }

        private boolean notEmpty(Collection val) {
            return null != val && val.size() > 0;
        }
    }

    public static class For {
        private List<TypeRule> job;
        private List<TypeRule> resource;
        private List<TypeRule> node;
        private List<TypeRule> user;
        private List<TypeRule> adhoc;
        private List<TypeRule> project;
        private List<TypeRule> apitoken;
        private List<TypeRule> type;

        public List<TypeRule> getJob() {
            return this.job;
        }

        public void setJob(List<TypeRule> job) {
            this.job = job;
        }

        public List<TypeRule> getResource() {
            return this.resource;
        }

        public void setResource(List<TypeRule> resource) {
            this.resource = resource;
        }

        public List<TypeRule> getNode() {
            return this.node;
        }

        public void setNode(List<TypeRule> node) {
            this.node = node;
        }

        public List<TypeRule> getUser() {
            return this.user;
        }

        public void setUser(List<TypeRule> user) {
            this.user = user;
        }

        public List<TypeRule> getAdhoc() {
            return this.adhoc;
        }

        public void setAdhoc(List<TypeRule> adhoc) {
            this.adhoc = adhoc;
        }

        public List<TypeRule> getProject() {
            return this.project;
        }

        public void setProject(List<TypeRule> project) {
            this.project = project;
        }

        public List<TypeRule> getApitoken() {
            return this.apitoken;
        }

        public void setApitoken(List<TypeRule> apitoken) {
            this.apitoken = apitoken;
        }

        public Map<String, List<TypeRule>> getRuleSets() {
            HashMap<String, List<TypeRule>> rules = new HashMap<String, List<TypeRule>>();
            if (null != this.job) {
                rules.put("job", this.job);
            }
            if (null != this.resource) {
                rules.put("resource", this.resource);
            }
            if (null != this.node) {
                rules.put("node", this.node);
            }
            if (null != this.user) {
                rules.put("user", this.user);
            }
            if (null != this.adhoc) {
                rules.put("adhoc", this.adhoc);
            }
            if (null != this.project) {
                rules.put("project", this.project);
            }
            if (null != this.apitoken) {
                rules.put("apitoken", this.apitoken);
            }
            if (null != this.type) {
                rules.put("type", this.type);
            }
            return rules;
        }

        public List<TypeRule> getType() {
            return this.type;
        }

        public void setType(List<TypeRule> type) {
            this.type = type;
        }

        public String toString() {
            return "For{" + (String)(this.job != null ? "job=" + this.job : "") + (String)(this.resource != null ? ", resource=" + this.resource : "") + (String)(this.node != null ? ", node=" + this.node : "") + (String)(this.user != null ? ", user=" + this.user : "") + (String)(this.adhoc != null ? ", adhoc=" + this.adhoc : "") + (String)(this.project != null ? ", project=" + this.project : "") + (String)(this.apitoken != null ? ", apitoken=" + this.apitoken : "") + (String)(this.type != null ? ", type=" + this.type : "") + "}";
        }

        public boolean isEmpty() {
            return this.getRuleSets().isEmpty();
        }
    }

    public static class Context {
        private String project;
        private String application;

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public String toString() {
            return "Context{" + (String)(null != this.project ? "project:'" + this.project + "'" : "") + (String)(null != this.application ? ", application:'" + this.application + "'" : "") + "}";
        }
    }
}

