/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers.yaml.model;

import com.dtolabs.rundeck.core.authorization.providers.yaml.model.ACLPolicyDoc;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlPolicyDocConstructor
extends Constructor {
    static Set<String> ALLOWED_POLICY_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("by", "notBy", "id", "for", "context", "description")));
    static Set<String> ALLOWED_CONTEXT_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("project", "application")));

    public YamlPolicyDocConstructor() {
        super(ACLPolicyDoc.class, new LoaderOptions());
        this.yamlConstructors.put(null, undefinedConstructor);
        this.yamlConstructors.put(new Tag(ACLPolicyDoc.class), new ACLPolicyDocConstructYamlObject());
        this.yamlClassConstructors.put(NodeId.mapping, new YamlPolicyDocConstruct());
        this.yamlClassConstructors.put(NodeId.scalar, new ACLPolicyDocEmptyConstructScalar());
    }

    class YamlPolicyDocConstruct
    extends Constructor.ConstructMapping {
        YamlPolicyDocConstruct() {
            super((Constructor)YamlPolicyDocConstructor.this);
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            block12: {
                Class type;
                block11: {
                    type = node.getType();
                    if (!type.equals(ACLPolicyDoc.Context.class)) break block11;
                    for (NodeTuple tuple : node.getValue()) {
                        if (!(tuple.getKeyNode() instanceof ScalarNode)) {
                            throw new YAMLException("Keys must be scalars but found: " + String.valueOf(tuple.getKeyNode()));
                        }
                        ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                        keyNode.setType(String.class);
                        String key = (String)YamlPolicyDocConstructor.this.constructObject((Node)keyNode);
                        if (ALLOWED_CONTEXT_KEYS.contains(key)) continue;
                        throw new YAMLException("Context section should contain only 'application:' or 'project:'");
                    }
                    break block12;
                }
                if (!type.equals(ACLPolicyDoc.class)) break block12;
                for (NodeTuple tuple : node.getValue()) {
                    if (!(tuple.getKeyNode() instanceof ScalarNode)) {
                        throw new YAMLException("Keys must be scalars but found: " + String.valueOf(tuple.getKeyNode()));
                    }
                    ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                    Node valueNode = tuple.getValueNode();
                    keyNode.setType(String.class);
                    String key = (String)YamlPolicyDocConstructor.this.constructObject((Node)keyNode);
                    if (!ALLOWED_POLICY_KEYS.contains(key)) {
                        throw new YAMLException(String.format("Policy contains invalid keys: [%s], allowed keys: [by, id, for, context, description]", key));
                    }
                    if (!"for".equals(key)) continue;
                    if (valueNode instanceof MappingNode) {
                        MappingNode forValue = (MappingNode)valueNode;
                        if (forValue.getValue().size() < 1) {
                            throw new YAMLException("Section 'for:' cannot be empty");
                        }
                        for (NodeTuple nodeTuple : forValue.getValue()) {
                            Node listNode = nodeTuple.getValueNode();
                            if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) {
                                throw new YAMLException("Keys must be scalars but found: " + String.valueOf(nodeTuple.getKeyNode()));
                            }
                            ScalarNode forkeyNode = (ScalarNode)nodeTuple.getKeyNode();
                            forkeyNode.setType(String.class);
                            String forkey = (String)YamlPolicyDocConstructor.this.constructObject((Node)forkeyNode);
                            if (listNode instanceof SequenceNode) {
                                SequenceNode seq = (SequenceNode)listNode;
                                seq.setType(List.class);
                                seq.setListType(ACLPolicyDoc.TypeRule.class);
                                List value = seq.getValue();
                                for (int x = 0; x < value.size(); ++x) {
                                    Node node1 = (Node)value.get(x);
                                    if (node1 instanceof MappingNode) continue;
                                    throw new YAMLException(String.format("Type rule 'for: { %s: [...] }' entry at index [%d] expected a Map but saw: %s", forkey, x + 1, node1.getNodeId()));
                                }
                                continue;
                            }
                            throw new YAMLException("Expected 'for: { " + forkey + ": <...> }' to be a Sequence, but was [" + String.valueOf(listNode.getNodeId()) + "]");
                        }
                        continue;
                    }
                    throw new YAMLException(String.format("Expected 'for:' section to contain a map, but was %s", valueNode.getNodeId()));
                }
            }
            return super.constructJavaBean2ndStep(node, object);
        }
    }

    class ACLPolicyDocConstructYamlObject
    extends Constructor.ConstructYamlObject {
        ACLPolicyDocConstructYamlObject() {
            super((Constructor)YamlPolicyDocConstructor.this);
        }
    }

    class ACLPolicyDocEmptyConstructScalar
    extends Constructor.ConstructScalar {
        ACLPolicyDocEmptyConstructScalar() {
            super((Constructor)YamlPolicyDocConstructor.this);
        }

        public Object construct(Node nnode) {
            ScalarNode scalarNode;
            if (nnode.getType() == ACLPolicyDoc.class && nnode instanceof ScalarNode && "".equals((scalarNode = (ScalarNode)nnode).getValue())) {
                return null;
            }
            return super.construct(nnode);
        }
    }
}

