/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class RunServer {
    public static final String SERVER_HTTP_HOST = "server.http.host";
    public static final String RUNDECK_JETTY_CONNECTOR_FORWARDED = "rundeck.jetty.connector.forwarded";
    public static final String RUNDECK_JETTY_SSL_CONNECTOR_EXCLUDED_PROTOCOLS = "rundeck.jetty.connector.ssl.excludedProtocols";
    public static final String RUNDECK_JETTY_SSL_CONNECTOR_INCLUDED_PROTOCOLS = "rundeck.jetty.connector.ssl.includedProtocols";
    public static final String RUNDECK_JETTY_SSL_CONNECTOR_EXCLUDED_CIPHER_SUITES = "rundeck.jetty.connector.ssl.excludedCipherSuites";
    public static final String RUNDECK_JETTY_SSL_CONNECTOR_INCLUDED_CIPHER_SUITES = "rundeck.jetty.connector.ssl.includedCipherSuites";
    public static final String DEFAULT_SSL_CONNECTER_EXCLUDED_PROTOCOLS = "SSLv3";
    public static final String DEFAULT_SSL_CONNECTER_INCLUDED_PROTOCOLS = null;
    public static final String DEFAULT_SSL_CONNECTER_EXCLUDED_CIPHER_SUITES = null;
    public static final String DEFAULT_SSL_CONNECTER_INCLUDED_CIPHER_SUITES = null;
    int port = Integer.getInteger("server.http.port", 4440);
    int httpsPort = Integer.getInteger("server.https.port", 4443);
    File basedir;
    File serverdir;
    private static final String REALM_NAME = "rundeckrealm";
    private static final String SYS_PROP_LOGIN_MODULE = "loginmodule.name";
    private static final String SYS_PROP_ROLE_CLASS_NAMES = "loginmodule.role.classnames";
    public static final String SYS_PROP_WEB_CONTEXT = "server.web.context";
    File configdir;
    File workdir;
    String loginmodulename;
    String roleclassnames;
    private boolean useJaas = null == System.getProperty("rundeck.jaaslogin") || Boolean.getBoolean("rundeck.jaaslogin");
    private static final String RUNDECK_JAASLOGIN = "rundeck.jaaslogin";
    public static final String RUNDECK_SSL_CONFIG = "rundeck.ssl.config";
    public static final String RUNDECK_KEYSTORE = "keystore";
    public static final String RUNDECK_KEYSTORE_PASSWORD = "keystore.password";
    public static final String RUNDECK_KEY_PASSWORD = "key.password";
    public static final String RUNDECK_TRUSTSTORE = "truststore";
    public static final String RUNDECK_TRUSTSTORE_PASSWORD = "truststore.password";
    private String keystore;
    private String keystorePassword;
    private String keyPassword;
    private String truststore;
    private String truststorePassword;
    private String appContext;
    private static final String RUNDECK_SERVER_SERVER_DIR = "rundeck.server.serverDir";
    private static final String RUNDECK_SERVER_CONFIG_DIR = "rundeck.server.configDir";
    private static final String RUNDECK_SERVER_WORK_DIR = "rundeck.server.workDir";

    public static void main(String[] args) throws Exception {
        new RunServer().run(args);
    }

    public RunServer() {
        this.loginmodulename = System.getProperty(SYS_PROP_LOGIN_MODULE, "rundecklogin");
        this.roleclassnames = System.getProperty(SYS_PROP_ROLE_CLASS_NAMES, null);
        this.appContext = System.getProperty(SYS_PROP_WEB_CONTEXT, "/");
    }

    public void run(String[] args) throws Exception {
        this.parseArgs(args);
        this.init();
        if (null != this.basedir) {
            System.setProperty("rdeck.base", this.basedir.getAbsolutePath());
        }
        Server server = new Server();
        if (this.isSSLEnabled()) {
            this.configureSSLConnector(server);
        } else {
            this.warnNoSSLConfig();
            this.configureHTTPConnector(server);
        }
        server.setStopAtShutdown(true);
        WebAppContext context = this.createWebAppContext(new File(this.serverdir, "exp/webapp"));
        server.setHandler((Handler)context);
        this.configureRealms(server);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    private void warnNoSSLConfig() {
        System.err.println("WARNING: HTTPS is not enabled, specify -Drundeck.ssl.config=" + this.basedir.getAbsolutePath().replaceAll("\\\\", "/") + "/server/config/ssl.properties to enable.");
    }

    private boolean isSSLEnabled() {
        if (null == System.getProperty(RUNDECK_SSL_CONFIG)) {
            return false;
        }
        if (null != this.keystore) {
            if (!new File(this.keystore).exists()) {
                System.err.println("ERROR: keystore file does not exist, you must create it: " + this.keystore);
                return false;
            }
        } else {
            System.err.println("ERROR: keystore property not specified: " + System.getProperty(RUNDECK_SSL_CONFIG));
            return false;
        }
        return true;
    }

    private void configureHTTPConnector(Server server) {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setOutputBufferSize(32768);
        if (Boolean.getBoolean(RUNDECK_JETTY_CONNECTOR_FORWARDED)) {
            ForwardedRequestCustomizer forwarding = new ForwardedRequestCustomizer();
            http_config.addCustomizer((HttpConfiguration.Customizer)forwarding);
        }
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        connector.setPort(this.port);
        connector.setHost(System.getProperty(SERVER_HTTP_HOST, null));
        server.addConnector((Connector)connector);
    }

    private void configureSSLConnector(Server server) {
        String includeCipherSuites;
        String excludeCipherSuites;
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.httpsPort);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        SslContextFactory cf = new SslContextFactory();
        cf.setKeyStorePath(this.keystore);
        cf.setKeyStorePassword(this.keystorePassword);
        cf.setKeyManagerPassword(this.keyPassword);
        cf.setTrustStorePath(this.truststore);
        cf.setTrustStorePassword(this.truststorePassword);
        cf.setExcludeProtocols(System.getProperty(RUNDECK_JETTY_SSL_CONNECTOR_EXCLUDED_PROTOCOLS, DEFAULT_SSL_CONNECTER_EXCLUDED_PROTOCOLS).split(","));
        String includedProtocols = System.getProperty(RUNDECK_JETTY_SSL_CONNECTOR_INCLUDED_PROTOCOLS, DEFAULT_SSL_CONNECTER_INCLUDED_PROTOCOLS);
        if (null != includedProtocols) {
            cf.setIncludeProtocols(includedProtocols.split(","));
        }
        if ((excludeCipherSuites = System.getProperty(RUNDECK_JETTY_SSL_CONNECTOR_EXCLUDED_CIPHER_SUITES, DEFAULT_SSL_CONNECTER_EXCLUDED_CIPHER_SUITES)) != null) {
            cf.setExcludeCipherSuites(excludeCipherSuites.split(","));
        }
        if ((includeCipherSuites = System.getProperty(RUNDECK_JETTY_SSL_CONNECTOR_INCLUDED_CIPHER_SUITES, DEFAULT_SSL_CONNECTER_INCLUDED_CIPHER_SUITES)) != null) {
            cf.setIncludeCipherSuites(includeCipherSuites.split(","));
        }
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(cf, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        if (Boolean.getBoolean(RUNDECK_JETTY_CONNECTOR_FORWARDED)) {
            ForwardedRequestCustomizer forwarding = new ForwardedRequestCustomizer();
            https_config.addCustomizer((HttpConfiguration.Customizer)forwarding);
        }
        https.setPort(this.httpsPort);
        https.setIdleTimeout(500000L);
        https.setHost(System.getProperty(SERVER_HTTP_HOST, null));
        server.setConnectors(new Connector[]{https});
    }

    private void configureRealms(Server server) throws IOException {
        if (this.useJaas) {
            this.configureJAASRealms(server);
        } else {
            this.configureHashRealms(server);
        }
    }

    private void configureHashRealms(Server server) throws IOException {
        HashLoginService realm = new HashLoginService();
        realm.setName(REALM_NAME);
        File conffile = new File(this.configdir, "realm.properties");
        realm.setConfig(conffile.getAbsolutePath());
        server.addBean((Object)realm);
    }

    private void configureJAASRealms(Server server) {
        JAASLoginService realm = new JAASLoginService();
        realm.setName(REALM_NAME);
        realm.setLoginModuleName(this.loginmodulename);
        if (null != this.roleclassnames && !"".equals(this.roleclassnames.trim())) {
            String[] strings = this.roleclassnames.split(",\\s*");
            realm.setRoleClassNames(strings);
        }
        server.addBean((Object)realm);
    }

    private WebAppContext createWebAppContext(File webapp) throws IOException {
        if (!webapp.isDirectory() || !new File(webapp, "WEB-INF").isDirectory()) {
            throw new RuntimeException("expected expanded webapp at location: " + webapp.getAbsolutePath());
        }
        WebAppContext context = new WebAppContext(webapp.getAbsolutePath(), this.appContext);
        context.setTempDirectory(this.workdir);
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        return context;
    }

    private void init() {
        this.serverdir = null != System.getProperty(RUNDECK_SERVER_SERVER_DIR) ? new File(System.getProperty(RUNDECK_SERVER_SERVER_DIR)) : new File(this.basedir, "server");
        this.configdir = null != System.getProperty(RUNDECK_SERVER_CONFIG_DIR) ? new File(System.getProperty(RUNDECK_SERVER_CONFIG_DIR)) : new File(this.serverdir, "config");
        this.workdir = null != System.getProperty(RUNDECK_SERVER_WORK_DIR) ? new File(System.getProperty(RUNDECK_SERVER_WORK_DIR)) : new File(this.serverdir, "work");
        if (null != System.getProperty(RUNDECK_SSL_CONFIG)) {
            Properties sslProperties = new Properties();
            try {
                sslProperties.load(new FileInputStream(System.getProperty(RUNDECK_SSL_CONFIG)));
            }
            catch (IOException e) {
                System.err.println("Could not load specified rundeck.ssl.config file: " + System.getProperty(RUNDECK_SSL_CONFIG) + ": " + e.getMessage());
                e.printStackTrace(System.err);
            }
            this.keystore = sslProperties.getProperty(RUNDECK_KEYSTORE);
            this.keystorePassword = sslProperties.getProperty(RUNDECK_KEYSTORE_PASSWORD);
            this.keyPassword = sslProperties.getProperty(RUNDECK_KEY_PASSWORD);
            this.truststore = sslProperties.getProperty(RUNDECK_TRUSTSTORE);
            this.truststorePassword = sslProperties.getProperty(RUNDECK_TRUSTSTORE_PASSWORD);
        }
    }

    private void parseArgs(String[] args) {
        if (args.length <= 0) {
            throw new RuntimeException("Basedir argument required");
        }
        this.basedir = new File(args[0]);
        if (args.length > 1) {
            this.port = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            this.httpsPort = Integer.parseInt(args[2]);
        }
    }
}

