/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlets.gzip.AbstractCompressedStream;
import org.eclipse.jetty.servlets.gzip.CompressedResponseWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    protected final Set<String> _mimeTypes = new HashSet<String>();
    protected boolean _excludeMimeTypes = false;
    protected Set<String> _excludedUA;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected String _vary = "Accept-Encoding, User-Agent";

    public Set<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._excludeMimeTypes = false;
        this._mimeTypes.clear();
        this._mimeTypes.addAll(mimeTypes);
    }

    public void setMimeTypes(String mimeTypes) {
        if (mimeTypes != null) {
            this._excludeMimeTypes = false;
            this._mimeTypes.clear();
            StringTokenizer tok = new StringTokenizer(mimeTypes, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken());
            }
        }
    }

    public void setExcludeMimeTypes(boolean exclude) {
        this._excludeMimeTypes = exclude;
    }

    public Set<String> getExcluded() {
        return this._excludedUA;
    }

    public void setExcluded(Set<String> excluded) {
        this._excludedUA = excluded;
    }

    public void setExcluded(String excluded) {
        if (excluded != null) {
            this._excludedUA = new HashSet<String>();
            StringTokenizer tok = new StringTokenizer(excluded, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedUA.add(tok.nextToken());
            }
        }
    }

    public String getVary() {
        return this._vary;
    }

    public void setVary(String vary) {
        this._vary = vary;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block11: {
            block12: {
                String ua;
                if (this._handler == null || !this.isStarted()) break block11;
                String ae = request.getHeader("accept-encoding");
                if (ae == null || ae.indexOf("gzip") < 0 || response.containsHeader("Content-Encoding") || HttpMethod.HEAD.is(request.getMethod())) break block12;
                if (this._excludedUA != null && this._excludedUA.contains(ua = request.getHeader("User-Agent"))) {
                    this._handler.handle(target, baseRequest, request, response);
                    return;
                }
                CompressedResponseWrapper wrappedResponse = this.newGzipResponseWrapper(request, response);
                boolean exceptional = true;
                try {
                    this._handler.handle(target, baseRequest, request, (HttpServletResponse)wrappedResponse);
                    exceptional = false;
                }
                catch (Throwable throwable) {
                    if (request.isAsyncStarted()) {
                        request.getAsyncContext().addListener(new AsyncListener(wrappedResponse){
                            final /* synthetic */ CompressedResponseWrapper val$wrappedResponse;
                            {
                                this.val$wrappedResponse = compressedResponseWrapper;
                            }

                            public void onTimeout(AsyncEvent event) throws IOException {
                            }

                            public void onStartAsync(AsyncEvent event) throws IOException {
                            }

                            public void onError(AsyncEvent event) throws IOException {
                            }

                            public void onComplete(AsyncEvent event) throws IOException {
                                try {
                                    this.val$wrappedResponse.finish();
                                }
                                catch (IOException e) {
                                    LOG.warn(e);
                                }
                            }
                        });
                    } else if (exceptional && !response.isCommitted()) {
                        wrappedResponse.resetBuffer();
                        wrappedResponse.noCompression();
                    } else {
                        wrappedResponse.finish();
                    }
                    throw throwable;
                }
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
                } else if (exceptional && !response.isCommitted()) {
                    wrappedResponse.resetBuffer();
                    wrappedResponse.noCompression();
                } else {
                    wrappedResponse.finish();
                }
                break block11;
            }
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    protected CompressedResponseWrapper newGzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new CompressedResponseWrapper(request, response){
            {
                super.setMimeTypes(GzipHandler.this._mimeTypes, GzipHandler.this._excludeMimeTypes);
                super.setBufferSize(GzipHandler.this._bufferSize);
                super.setMinCompressSize(GzipHandler.this._minGzipSize);
            }

            @Override
            protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return new AbstractCompressedStream("gzip", request, this, GzipHandler.this._vary){

                    @Override
                    protected DeflaterOutputStream createStream() throws IOException {
                        return new GZIPOutputStream((OutputStream)this._response.getOutputStream(), GzipHandler.this._bufferSize);
                    }
                };
            }

            @Override
            protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
                return GzipHandler.this.newWriter(out, encoding);
            }
        };
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }
}

