/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Object;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.commons.ssl.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.commons.ssl.org.bouncycastle.asn1.DERSequence;
import org.apache.commons.ssl.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.commons.ssl.org.bouncycastle.asn1.x509.GeneralSubtree;

public class NameConstraints
extends ASN1Object {
    private GeneralSubtree[] permitted;
    private GeneralSubtree[] excluded;

    public static NameConstraints getInstance(Object obj) {
        if (obj instanceof NameConstraints) {
            return (NameConstraints)obj;
        }
        if (obj != null) {
            return new NameConstraints(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private NameConstraints(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject o = ASN1TaggedObject.getInstance(e.nextElement());
            switch (o.getTagNo()) {
                case 0: {
                    this.permitted = this.createArray(ASN1Sequence.getInstance(o, false));
                    break;
                }
                case 1: {
                    this.excluded = this.createArray(ASN1Sequence.getInstance(o, false));
                }
            }
        }
    }

    public NameConstraints(GeneralSubtree[] permitted, GeneralSubtree[] excluded) {
        if (permitted != null) {
            this.permitted = permitted;
        }
        if (excluded != null) {
            this.excluded = excluded;
        }
    }

    private GeneralSubtree[] createArray(ASN1Sequence subtree) {
        GeneralSubtree[] ar = new GeneralSubtree[subtree.size()];
        for (int i = 0; i != ar.length; ++i) {
            ar[i] = GeneralSubtree.getInstance(subtree.getObjectAt(i));
        }
        return ar;
    }

    public GeneralSubtree[] getPermittedSubtrees() {
        return this.permitted;
    }

    public GeneralSubtree[] getExcludedSubtrees() {
        return this.excluded;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.permitted != null) {
            v.add(new DERTaggedObject(false, 0, new DERSequence(this.permitted)));
        }
        if (this.excluded != null) {
            v.add(new DERTaggedObject(false, 1, new DERSequence(this.excluded)));
        }
        return new DERSequence(v);
    }
}

