/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.jetty;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.spi.PropertyFileLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.rundeck.jaas.AbstractSharedLoginModule;
import org.rundeck.jaas.jetty.JettySupport;

public class JettyRolePropertyFileLoginModule
extends AbstractSharedLoginModule {
    public static final Logger logger = Logger.getLogger(JettyRolePropertyFileLoginModule.class.getName());
    PropertyFileLoginModule module;
    UserInfo userInfo;
    boolean caseInsensitive = true;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> shared, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, shared, options);
        if (!this.getSharedLoginCreds().isUseFirstPass() && !this.getSharedLoginCreds().isTryFirstPass()) {
            throw new IllegalStateException("JettyRolePropertyFileLoginModule must have useFirstPass or tryFirstPass set to true");
        }
        Object caseInsensitiveStr = options.get("caseInsensitive");
        if (null != caseInsensitiveStr) {
            this.caseInsensitive = Boolean.parseBoolean(caseInsensitiveStr.toString());
        }
        this.module = new PropertyFileLoginModule();
        this.module.initialize(subject, callbackHandler, shared, options);
    }

    @Override
    protected Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException {
        if (this.getSharedLoginCreds().isHasSharedAuth()) {
            return new Object[]{this.getSharedLoginCreds().getSharedUserName(), this.getSharedLoginCreds().getSharedUserPass().toString().toCharArray()};
        }
        return new Object[]{null, null};
    }

    @Override
    protected Principal createUserPrincipal() {
        return null;
    }

    @Override
    protected List<Principal> createRolePrincipals() {
        ArrayList<Principal> roles = new ArrayList<Principal>();
        if (null != this.userInfo) {
            List roleNames = this.userInfo.getRoleNames();
            this.debug(String.format("role names: %s", roleNames));
            for (Object roleName : roleNames) {
                roles.add(this.createRolePrincipal(roleName.toString()));
            }
        }
        return roles;
    }

    protected Principal createRolePrincipal(String role) {
        return JettySupport.createRolePrincipal(role);
    }

    @Override
    protected boolean authenticate(String sharedUserName, char[] chars) throws LoginException {
        block3: {
            if (!this.getSharedLoginCreds().isHasSharedAuth()) {
                this.debug("JettyRolePropertyFileLoginModule: no shared auth, skipping.");
                return false;
            }
            try {
                this.userInfo = this.module.getUserInfo(this.caseInsensitive ? sharedUserName.toLowerCase() : sharedUserName);
                this.debug(String.format("JettyRolePropertyFileLoginModule: userInfo found for %s? %s", sharedUserName, this.userInfo != null));
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    protected void debug(String message) {
        logger.log(Level.INFO, message);
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.userInfo = null;
        }
        return super.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        this.userInfo = null;
        return super.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        this.userInfo = null;
        return super.logout();
    }
}

