/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ResourceHandler.class);
    ContextHandler _context;
    Resource _baseResource;
    Resource _defaultStylesheet;
    Resource _stylesheet;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes = new MimeTypes();
    String _cacheControl;
    boolean _directory;
    boolean _etags;
    int _minMemoryMappedContentLength = -1;
    int _minAsyncContentLength = 0;

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public boolean isDirectoriesListed() {
        return this._directory;
    }

    public void setDirectoriesListed(boolean directory) {
        this._directory = directory;
    }

    public int getMinMemoryMappedContentLength() {
        return this._minMemoryMappedContentLength;
    }

    public void setMinMemoryMappedContentLength(int minMemoryMappedFileSize) {
        this._minMemoryMappedContentLength = minMemoryMappedFileSize;
    }

    public int getMinAsyncContentLength() {
        return this._minAsyncContentLength;
    }

    public void setMinAsyncContentLength(int minAsyncContentLength) {
        this._minAsyncContentLength = minAsyncContentLength;
    }

    public boolean isEtags() {
        return this._etags;
    }

    public void setEtags(boolean etags) {
        this._etags = etags;
    }

    @Override
    public void doStart() throws Exception {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        this._context = scontext == null ? null : scontext.getContextHandler();
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public Resource getStylesheet() {
        if (this._stylesheet != null) {
            return this._stylesheet;
        }
        if (this._defaultStylesheet == null) {
            try {
                this._defaultStylesheet = Resource.newResource(this.getClass().getResource("/jetty-dir.css"));
            }
            catch (IOException e) {
                LOG.warn(e.toString(), new Object[0]);
                LOG.debug(e);
            }
        }
        return this._defaultStylesheet;
    }

    public void setStylesheet(String stylesheet) {
        try {
            this._stylesheet = Resource.newResource(stylesheet);
            if (!this._stylesheet.exists()) {
                LOG.warn("unable to find custom stylesheet: " + stylesheet, new Object[0]);
                this._stylesheet = null;
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            throw new IllegalArgumentException(stylesheet);
        }
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        Resource base = this._baseResource;
        if (base == null) {
            if (this._context == null) {
                return null;
            }
            base = this._context.getBaseResource();
            if (base == null) {
                return null;
            }
        }
        try {
            path = URIUtil.canonicalPath(path);
            return base.addPath(path);
        }
        catch (Exception e) {
            LOG.ignore(e);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest request) throws MalformedURLException {
        String pathInfo;
        String servletPath;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null && pathInfo == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        return this.getResource(pathInContext);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this._welcomeFiles = welcomeFiles;
    }

    protected Resource getWelcome(Resource directory) throws MalformedURLException, IOException {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource welcome = directory.addPath(this._welcomeFiles[i]);
            if (!welcome.exists() || welcome.isDirectory()) continue;
            return welcome;
        }
        return null;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long if_modified;
        Resource resource;
        if (baseRequest.isHandled()) {
            return;
        }
        boolean skipContentBody = false;
        if (!HttpMethod.GET.is(request.getMethod())) {
            if (!HttpMethod.HEAD.is(request.getMethod())) {
                super.handle(target, baseRequest, request, response);
                return;
            }
            skipContentBody = true;
        }
        if ((resource = this.getResource(request)) == null || !resource.exists()) {
            if (target.endsWith("/jetty-dir.css")) {
                resource = this.getStylesheet();
                if (resource == null) {
                    return;
                }
                response.setContentType("text/css");
            } else {
                super.handle(target, baseRequest, request, response);
                return;
            }
        }
        baseRequest.setHandled(true);
        if (resource.isDirectory()) {
            if (!request.getPathInfo().endsWith("/")) {
                response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getRequestURI(), "/")));
                return;
            }
            Resource welcome = this.getWelcome(resource);
            if (welcome != null && welcome.exists()) {
                resource = welcome;
            } else {
                this.doDirectory(request, response, resource);
                baseRequest.setHandled(true);
                return;
            }
        }
        long last_modified = resource.lastModified();
        String etag = null;
        if (this._etags) {
            String ifnm = request.getHeader(HttpHeader.IF_NONE_MATCH.asString());
            etag = resource.getWeakETag();
            if (ifnm != null && resource != null && ifnm.equals(etag)) {
                response.setStatus(304);
                baseRequest.getResponse().getHttpFields().put(HttpHeader.ETAG, etag);
                return;
            }
        }
        if (last_modified > 0L && (if_modified = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())) > 0L && last_modified / 1000L <= if_modified / 1000L) {
            response.setStatus(304);
            return;
        }
        String mime = this._mimeTypes.getMimeByExtension(resource.toString());
        if (mime == null) {
            mime = this._mimeTypes.getMimeByExtension(request.getPathInfo());
        }
        this.doResponseHeaders(response, resource, mime);
        if (this._etags) {
            baseRequest.getResponse().getHttpFields().put(HttpHeader.ETAG, etag);
        }
        if (skipContentBody) {
            return;
        }
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (!(out instanceof HttpOutput)) {
            resource.writeTo((OutputStream)out, 0L, resource.length());
        } else {
            int min_async_size;
            int n = min_async_size = this._minAsyncContentLength == 0 ? response.getBufferSize() : this._minAsyncContentLength;
            if (request.isAsyncSupported() && min_async_size > 0 && resource.length() >= (long)min_async_size) {
                final AsyncContext async = request.startAsync();
                Callback callback = new Callback(){

                    @Override
                    public void succeeded() {
                        async.complete();
                    }

                    @Override
                    public void failed(Throwable x) {
                        LOG.warn(x.toString(), new Object[0]);
                        LOG.debug(x);
                        async.complete();
                    }
                };
                if (this._minMemoryMappedContentLength > 0 && resource.length() > (long)this._minMemoryMappedContentLength && resource instanceof FileResource) {
                    ByteBuffer buffer = BufferUtil.toBuffer(resource.getFile());
                    ((HttpOutput)((Object)out)).sendContent(buffer, callback);
                } else {
                    ReadableByteChannel channel = resource.getReadableByteChannel();
                    if (channel != null) {
                        ((HttpOutput)((Object)out)).sendContent(channel, callback);
                    } else {
                        ((HttpOutput)((Object)out)).sendContent(resource.getInputStream(), callback);
                    }
                }
            } else if (this._minMemoryMappedContentLength > 0 && resource.length() > (long)this._minMemoryMappedContentLength && resource instanceof FileResource) {
                ByteBuffer buffer = BufferUtil.toBuffer(resource.getFile());
                ((HttpOutput)((Object)out)).sendContent(buffer);
            } else {
                ReadableByteChannel channel = resource.getReadableByteChannel();
                if (channel != null) {
                    ((HttpOutput)((Object)out)).sendContent(channel);
                } else {
                    ((HttpOutput)((Object)out)).sendContent(resource.getInputStream());
                }
            }
        }
    }

    protected void doDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (this._directory) {
            String listing = resource.getListHTML(request.getRequestURI(), request.getPathInfo().lastIndexOf("/") > 0);
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().println(listing);
        } else {
            response.sendError(403);
        }
    }

    protected void doResponseHeaders(HttpServletResponse response, Resource resource, String mimeType) {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        long length = resource.length();
        if (response instanceof Response) {
            HttpFields fields = ((Response)response).getHttpFields();
            if (length > 0L) {
                ((Response)response).setLongContentLength(length);
            }
            if (this._cacheControl != null) {
                fields.put(HttpHeader.CACHE_CONTROL, this._cacheControl);
            }
        } else {
            if (length > Integer.MAX_VALUE) {
                response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(length));
            } else if (length > 0L) {
                response.setContentLength((int)length);
            }
            if (this._cacheControl != null) {
                response.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl);
            }
        }
    }
}

