/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.jetty;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.spi.PropertyFileLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.rundeck.jaas.AbstractSharedLoginModule;
import org.rundeck.jaas.jetty.JettySupport;

public class JettyAuthPropertyFileLoginModule
extends AbstractSharedLoginModule {
    public static final Logger logger = Logger.getLogger(JettyAuthPropertyFileLoginModule.class.getName());
    PropertyFileLoginModule module;
    UserInfo userInfo;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map shared, Map options) {
        super.initialize(subject, callbackHandler, shared, options);
        this.module = new PropertyFileLoginModule();
        this.module.initialize(subject, callbackHandler, shared, options);
    }

    @Override
    protected Object[] getCallBackAuth() throws IOException, UnsupportedCallbackException, LoginException {
        return JettySupport.performCallbacks(this.getCallbackHandler());
    }

    @Override
    protected Principal createUserPrincipal() {
        return JettySupport.createUserPrincipal(this.userInfo.getUserName());
    }

    @Override
    protected List<Principal> createRolePrincipals() {
        return null;
    }

    @Override
    protected boolean authenticate(String userName, char[] chars) throws LoginException {
        try {
            this.userInfo = this.module.getUserInfo(userName);
            if (null == this.userInfo) {
                this.debug(String.format("JettyAuthPropertyFileLoginModule: userInfo not found for %s", userName));
                return false;
            }
            boolean b = this.userInfo.checkCredential((Object)new String(chars));
            this.debug(String.format("JettyAuthPropertyFileLoginModule: checkCredential? %s", b));
            return b;
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.userInfo = null;
        }
        return super.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        this.userInfo = null;
        return super.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        this.userInfo = null;
        return super.logout();
    }

    @Override
    protected void debug(String message) {
        logger.log(Level.INFO, message);
    }
}

