/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.servlets.UserAgentFilter;
import org.eclipse.jetty.servlets.gzip.AbstractCompressedStream;
import org.eclipse.jetty.servlets.gzip.CompressedResponseWrapper;
import org.eclipse.jetty.servlets.gzip.GzipOutputStream;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipFilter
extends UserAgentFilter {
    private static final Logger LOG = Log.getLogger(GzipFilter.class);
    public static final String GZIP = "gzip";
    public static final String ETAG_GZIP = "--gzip\"";
    public static final String DEFLATE = "deflate";
    public static final String ETAG_DEFLATE = "--deflate\"";
    public static final String ETAG = "o.e.j.s.GzipFilter.ETag";
    protected ServletContext _context;
    protected final Set<String> _mimeTypes = new HashSet<String>();
    protected boolean _excludeMimeTypes;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected int _deflateCompressionLevel = -1;
    protected boolean _deflateNoWrap = true;
    protected boolean _checkGzExists = true;
    protected final ThreadLocal<Deflater> _deflater = new ThreadLocal();
    protected final Set<String> _methods = new HashSet<String>();
    protected Set<String> _excludedAgents;
    protected Set<Pattern> _excludedAgentPatterns;
    protected Set<String> _excludedPaths;
    protected Set<Pattern> _excludedPathPatterns;
    protected String _vary = "Accept-Encoding, User-Agent";
    private static final int STATE_SEPARATOR = 0;
    private static final int STATE_Q = 1;
    private static final int STATE_QVALUE = 2;
    private static final int STATE_DEFAULT = 3;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        StringTokenizer tok;
        super.init(filterConfig);
        this._context = filterConfig.getServletContext();
        String tmp = filterConfig.getInitParameter("bufferSize");
        if (tmp != null) {
            this._bufferSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("minGzipSize")) != null) {
            this._minGzipSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("deflateCompressionLevel")) != null) {
            this._deflateCompressionLevel = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("deflateNoWrap")) != null) {
            this._deflateNoWrap = Boolean.parseBoolean(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("checkGzExists")) != null) {
            this._checkGzExists = Boolean.parseBoolean(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("methods")) != null) {
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._methods.add(tok.nextToken().trim().toUpperCase());
            }
        } else {
            this._methods.add(HttpMethod.GET.asString());
        }
        tmp = filterConfig.getInitParameter("mimeTypes");
        if (tmp == null) {
            this._excludeMimeTypes = true;
            tmp = filterConfig.getInitParameter("excludedMimeTypes");
            if (tmp == null) {
                for (String type : MimeTypes.getKnownMimeTypes()) {
                    if (type.startsWith("image/") || type.startsWith("audio/") || type.startsWith("video/")) {
                        this._mimeTypes.add(type);
                    }
                    this._mimeTypes.add("application/compress");
                    this._mimeTypes.add("application/zip");
                    this._mimeTypes.add("application/gzip");
                }
            } else {
                tok = new StringTokenizer(tmp, ",", false);
                while (tok.hasMoreTokens()) {
                    this._mimeTypes.add(tok.nextToken());
                }
            }
        } else {
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludedAgents")) != null) {
            this._excludedAgents = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedAgents.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludeAgentPatterns")) != null) {
            this._excludedAgentPatterns = new HashSet<Pattern>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedAgentPatterns.add(Pattern.compile(tok.nextToken()));
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludePaths")) != null) {
            this._excludedPaths = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPaths.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludePathPatterns")) != null) {
            this._excludedPathPatterns = new HashSet<Pattern>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPathPatterns.add(Pattern.compile(tok.nextToken()));
            }
        }
        if ((tmp = filterConfig.getInitParameter("vary")) != null) {
            this._vary = tmp;
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        int dd;
        File gz;
        String path;
        String mimeType;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestURI = request.getRequestURI();
        if (!this._methods.contains(request.getMethod()) || this.isExcludedPath(requestURI)) {
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        if (this._mimeTypes.size() > 0 && (mimeType = this._context.getMimeType(request.getRequestURI())) != null && this._mimeTypes.contains(mimeType) == this._excludeMimeTypes) {
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        if (this._checkGzExists && request.getServletContext() != null && (path = request.getServletContext().getRealPath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo()))) != null && (gz = new File(path + ".gz")).exists()) {
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        String ua = this.getUserAgent((ServletRequest)request);
        boolean ua_excluded = ua != null && this.isExcludedAgent(ua);
        String compressionType = ua_excluded ? null : this.selectCompression(request.getHeader("accept-encoding"));
        String etag = request.getHeader("If-None-Match");
        if (etag != null && (dd = etag.indexOf("--")) > 0) {
            request.setAttribute(ETAG, (Object)(etag.substring(0, dd) + (etag.endsWith("\"") ? "\"" : "")));
        }
        CompressedResponseWrapper wrappedResponse = this.createWrappedResponse(request, response, compressionType);
        boolean exceptional = true;
        try {
            super.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse, chain);
            exceptional = false;
        }
        finally {
            if (request.isAsyncStarted()) {
                request.getAsyncContext().addListener((AsyncListener)new FinishOnCompleteListener(wrappedResponse));
            } else if (exceptional && !response.isCommitted()) {
                wrappedResponse.resetBuffer();
                wrappedResponse.noCompression();
            } else {
                wrappedResponse.finish();
            }
        }
    }

    private String selectCompression(String encodingHeader) {
        String[] encodings;
        String compression = null;
        if (encodingHeader != null && (encodings = this.getEncodings(encodingHeader)) != null) {
            for (int i = 0; i < encodings.length; ++i) {
                if (encodings[i].toLowerCase(Locale.ENGLISH).contains(GZIP) && this.isEncodingAcceptable(encodings[i])) {
                    compression = GZIP;
                    break;
                }
                if (!encodings[i].toLowerCase(Locale.ENGLISH).contains(DEFLATE) || !this.isEncodingAcceptable(encodings[i])) continue;
                compression = DEFLATE;
            }
        }
        return compression;
    }

    private String[] getEncodings(String encodingHeader) {
        if (encodingHeader == null) {
            return null;
        }
        return encodingHeader.split(",");
    }

    private boolean isEncodingAcceptable(String encoding) {
        int state = 3;
        int qvalueIdx = -1;
        block6: for (int i = 0; i < encoding.length(); ++i) {
            char c = encoding.charAt(i);
            switch (state) {
                case 3: {
                    if (';' != c) continue block6;
                    state = 0;
                    continue block6;
                }
                case 0: {
                    if ('q' != c && 'Q' != c) continue block6;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if ('=' != c) continue block6;
                    state = 2;
                    continue block6;
                }
                case 2: {
                    if ((qvalueIdx >= 0 || '0' != c) && '1' != c) continue block6;
                    qvalueIdx = i;
                }
            }
        }
        if (qvalueIdx < 0) {
            return true;
        }
        return !"0".equals(encoding.substring(qvalueIdx).trim());
    }

    protected CompressedResponseWrapper createWrappedResponse(HttpServletRequest request, HttpServletResponse response, final String compressionType) {
        CompressedResponseWrapper wrappedResponse = null;
        wrappedResponse = new CompressedResponseWrapper(request, response){

            @Override
            protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return new AbstractCompressedStream(compressionType, request, this, GzipFilter.this._vary){
                    private Deflater _allocatedDeflater;

                    @Override
                    protected DeflaterOutputStream createStream() throws IOException {
                        if (compressionType == null) {
                            return null;
                        }
                        this._allocatedDeflater = GzipFilter.this._deflater.get();
                        if (this._allocatedDeflater == null) {
                            this._allocatedDeflater = new Deflater(GzipFilter.this._deflateCompressionLevel, GzipFilter.this._deflateNoWrap);
                        } else {
                            GzipFilter.this._deflater.remove();
                            this._allocatedDeflater.reset();
                        }
                        switch (compressionType) {
                            case "gzip": {
                                return new GzipOutputStream((OutputStream)this._response.getOutputStream(), this._allocatedDeflater, GzipFilter.this._bufferSize);
                            }
                            case "deflate": {
                                return new DeflaterOutputStream((OutputStream)this._response.getOutputStream(), this._allocatedDeflater, GzipFilter.this._bufferSize);
                            }
                        }
                        throw new IllegalStateException(compressionType + " not supported");
                    }

                    @Override
                    public void finish() throws IOException {
                        super.finish();
                        if (this._allocatedDeflater != null && GzipFilter.this._deflater.get() == null) {
                            GzipFilter.this._deflater.set(this._allocatedDeflater);
                        }
                    }
                };
            }
        };
        this.configureWrappedResponse(wrappedResponse);
        return wrappedResponse;
    }

    protected void configureWrappedResponse(CompressedResponseWrapper wrappedResponse) {
        wrappedResponse.setMimeTypes(this._mimeTypes, this._excludeMimeTypes);
        wrappedResponse.setBufferSize(this._bufferSize);
        wrappedResponse.setMinCompressSize(this._minGzipSize);
    }

    private boolean isExcludedAgent(String ua) {
        if (ua == null) {
            return false;
        }
        if (this._excludedAgents != null && this._excludedAgents.contains(ua)) {
            return true;
        }
        if (this._excludedAgentPatterns != null) {
            for (Pattern pattern : this._excludedAgentPatterns) {
                if (!pattern.matcher(ua).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcludedPath(String requestURI) {
        if (requestURI == null) {
            return false;
        }
        if (this._excludedPaths != null) {
            for (String excludedPath : this._excludedPaths) {
                if (!requestURI.startsWith(excludedPath)) continue;
                return true;
            }
        }
        if (this._excludedPathPatterns != null) {
            for (Pattern pattern : this._excludedPathPatterns) {
                if (!pattern.matcher(requestURI).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private class FinishOnCompleteListener
    implements AsyncListener {
        private CompressedResponseWrapper wrappedResponse;

        public FinishOnCompleteListener(CompressedResponseWrapper wrappedResponse) {
            this.wrappedResponse = wrappedResponse;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            try {
                this.wrappedResponse.finish();
            }
            catch (IOException e) {
                LOG.warn(e);
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }
}

