/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.CLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnixUser {
    private final String userName;
    private final int uid;
    private final int gid;
    private final Set<String> groups;

    UnixUser(String userName, CLibrary.passwd pwd) throws PAMException {
        Memory m;
        int ngroups;
        int sz;
        block4: {
            this.userName = userName;
            this.uid = pwd.pw_uid;
            this.gid = pwd.pw_gid;
            sz = 4;
            ngroups = 64;
            m = new Memory((long)(ngroups * sz));
            IntByReference pngroups = new IntByReference(ngroups);
            try {
                if (CLibrary.libc.getgrouplist(userName, pwd.pw_gid, m, pngroups) < 0 && CLibrary.libc.getgrouplist(userName, pwd.pw_gid, m = new Memory((long)(pngroups.getValue() * sz)), pngroups) < 0) {
                    throw new PAMException("getgrouplist failed");
                }
                ngroups = pngroups.getValue();
            }
            catch (LinkageError e) {
                ngroups = CLibrary.libc._getgroupsbymember(userName, m, ngroups, 0);
                if (ngroups >= 0) break block4;
                throw new PAMException("_getgroupsbymember failed");
            }
        }
        this.groups = new HashSet<String>();
        for (int i = 0; i < ngroups; ++i) {
            int gid = m.getInt((long)(i * sz));
            CLibrary.group grp = CLibrary.libc.getgrgid(gid);
            if (grp == null) continue;
            this.groups.add(grp.gr_name);
        }
    }

    public UnixUser(String userName) throws PAMException {
        this(userName, CLibrary.passwd.loadPasswd(userName));
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUID() {
        return this.uid;
    }

    public int getGID() {
        return this.gid;
    }

    public Set<String> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    public static boolean exists(String name) {
        return CLibrary.libc.getpwnam(name) != null;
    }
}

