/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.jetty.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.callback.ObjectCallback;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class JNDILoginModule
extends AbstractLoginModule {
    private static final Logger log = Log.getLogger(JNDILoginModule.class);
    public static final String DEFAULT_FILENAME = "rundeck-jndi.properties";
    private HashMap fileMap = new HashMap();
    private String propertyFileName;
    public static final String CONNECTION_NAME_PROP = "rundeck.auth.jndi.connectionName";
    public static final String CONNECTION_PASS_PROP = "rundeck.auth.jndi.connectionPassword";
    public static final String CONNECTION_URL_PROP = "rundeck.auth.jndi.connectionUrl";
    public static final String CONNECTION_AUTH_TYPE = "rundeck.auth.jndi.authType";
    public static final String ROLEBASE_PROP = "rundeck.auth.jndi.roleBase";
    public static final String ROLENAMERDN_PROP = "rundeck.auth.jndi.roleNameRDN";
    public static final String ROLEMEMBERRDN_PROP = "rundeck.auth.jndi.roleMemberRDN";
    public static final String USERBASE_PROP = "rundeck.auth.jndi.userBase";
    public static final String USERNAMERDN_PROP = "rundeck.auth.jndi.userNameRDN";
    public static final String PROJECT_ROLE_NAME_PREFIX = "projectRole-";
    private String connectionUrl;
    private String connectionName;
    private String connectionPassword;
    private String connectionAuth;
    private String roleBase;
    private String roleNameRDN;
    private String roleMemberRDN;
    private String userBase;
    private String userNameRDN;
    private DirContext initialDirContext;
    public static final String RESTRICTED_PROJECTS_ROLE = "restrictedProjects";

    public UserInfo getUserInfo(String username) throws Exception {
        DirContext dir = this.context();
        ArrayList roleList = new ArrayList(this.getUserRoles(username));
        String credentials = this.getUserCredentials(username);
        return new UserInfo(username, Credential.getCredential((String)credentials), roleList);
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        Properties props = this.loadProperties((String)options.get("file"));
        this.initWithProps(props);
    }

    private void initWithProps(Properties props) {
        this.connectionUrl = props.getProperty(CONNECTION_URL_PROP);
        this.connectionName = props.getProperty(CONNECTION_NAME_PROP);
        this.connectionPassword = props.getProperty(CONNECTION_PASS_PROP);
        this.connectionAuth = props.containsKey(CONNECTION_AUTH_TYPE) ? props.getProperty(CONNECTION_AUTH_TYPE) : "simple";
        this.roleBase = props.getProperty(ROLEBASE_PROP);
        this.roleNameRDN = props.getProperty(ROLENAMERDN_PROP);
        this.roleMemberRDN = props.getProperty(ROLEMEMBERRDN_PROP);
        this.userBase = props.getProperty(USERBASE_PROP);
        this.userNameRDN = props.getProperty(USERNAMERDN_PROP);
    }

    private synchronized DirContext context() throws NamingException {
        if (null == this.initialDirContext) {
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.connectionUrl);
            env.put("java.naming.security.principal", this.connectionName);
            env.put("java.naming.security.credentials", this.connectionPassword);
            this.initialDirContext = new InitialDirContext(env);
        }
        return this.initialDirContext;
    }

    private synchronized boolean authbindContext(String userName, String pass) throws NamingException {
        String userDN = this.userNameRDN + "=" + userName + "," + this.userBase;
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.connectionUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", pass);
        log.debug("attempting bind with userDN: " + userDN, new Object[0]);
        InitialDirContext ctx = new InitialDirContext(env);
        try {
            ctx.lookup(userDN);
            ctx.close();
            log.debug("bind succeeded", new Object[0]);
            return true;
        }
        catch (NamingException e) {
            log.debug("bind failed", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean login() throws LoginException {
        if ("simple".equals(this.connectionAuth)) {
            return super.login();
        }
        if ("bind".equals(this.connectionAuth)) {
            log.debug("login using bind", new Object[0]);
            try {
                if (this.getCallbackHandler() == null) {
                    throw new LoginException("No callback handler");
                }
                Callback[] callbacks = this.configureCallbacks();
                this.getCallbackHandler().handle(callbacks);
                String webUserName = ((NameCallback)callbacks[0]).getName();
                Object webCredential = ((ObjectCallback)callbacks[1]).getObject();
                if (webUserName == null || webCredential == null) {
                    this.setAuthenticated(false);
                    return this.isAuthenticated();
                }
                ArrayList roleList = new ArrayList(this.getUserRoles(webUserName));
                UserInfo userInfo = new UserInfo(webUserName, null, roleList);
                log.debug("userRoles: " + roleList, new Object[0]);
                if (userInfo == null) {
                    this.setAuthenticated(false);
                    return this.isAuthenticated();
                }
                this.setCurrentUser(new AbstractLoginModule.JAASUserInfo((AbstractLoginModule)this, userInfo));
                this.setAuthenticated(this.authbindContext(webUserName, (String)webCredential));
                log.debug("login returning: isAuthenticated? " + this.isAuthenticated(), new Object[0]);
                return this.isAuthenticated();
            }
            catch (IOException e) {
                log.warn((Throwable)e);
                throw new LoginException(e.toString());
            }
            catch (UnsupportedCallbackException e) {
                log.warn((Throwable)e);
                throw new LoginException(e.toString());
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                throw new LoginException(e.toString());
            }
        }
        throw new IllegalStateException("rundeck.auth.jndi.authType was an unrecognized value: " + this.connectionAuth);
    }

    private Properties loadProperties(String filename) {
        File propsFile;
        if (filename == null) {
            propsFile = new File(System.getProperty("jetty.home"), DEFAULT_FILENAME);
        } else {
            propsFile = new File(filename);
            if (!propsFile.exists()) {
                propsFile = new File(System.getProperty("jetty.home"), filename);
            }
        }
        if (!propsFile.exists()) {
            log.warn("No property file found: " + propsFile.getAbsolutePath(), new Object[0]);
            throw new IllegalStateException("No property file specified in login module configuration file, or it does not exist");
        }
        try {
            this.propertyFileName = propsFile.getCanonicalPath();
            if (this.fileMap.get(this.propertyFileName) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Properties file " + this.propertyFileName + " already in cache, skipping load", new Object[0]);
                }
                return (Properties)this.fileMap.get(this.propertyFileName);
            }
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            this.fileMap.put(this.propertyFileName, props);
            return props;
        }
        catch (Exception e) {
            log.warn("Error loading properties from file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Collection getUserRoles(String userName) throws NamingException {
        log.debug("Obtaining roles for userName: " + userName, new Object[0]);
        String filter = "(" + this.roleMemberRDN + "=" + this.userNameRDN + "=" + userName + "," + this.userBase + ")";
        NamingEnumeration roleResults = this.search(this.roleBase, filter, new String[]{this.roleMemberRDN});
        ArrayList<String> results = new ArrayList<String>();
        while (roleResults != null && roleResults.hasMore()) {
            SearchResult roleResult = (SearchResult)roleResults.next();
            String roleResultName = roleResult.getName();
            if ("".equals(roleResultName)) continue;
            String roleResultValue = roleResultName.split("=")[1];
            results.add(roleResultValue);
        }
        return results;
    }

    private String getUserCredentials(String userName) throws NamingException {
        log.debug("Obtaining credentials for userName: " + userName, new Object[0]);
        DirContext dirContext = this.context();
        String userDN = this.userNameRDN + "=" + userName + "," + this.userBase;
        Attributes roleAttrs = dirContext.getAttributes(userDN);
        Attribute unique = roleAttrs.get("userPassword");
        Object o = unique.get();
        if (o instanceof byte[]) {
            String p = new String((byte[])o);
            return p;
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new NamingException("unexpected datatype for password field");
    }

    private Map getUsers() throws NamingException {
        String filter = "(" + this.roleNameRDN + "=*)";
        HashMap<String, HashSet> users = new HashMap<String, HashSet>();
        NamingEnumeration results = this.search(this.roleBase, filter, new String[]{this.roleMemberRDN});
        while (results != null && results.hasMore()) {
            SearchResult roleResult = (SearchResult)results.next();
            String roleResultName = roleResult.getName();
            if ("".equals(roleResultName)) continue;
            String roleResultValue = roleResultName.split("=")[1];
            Attributes roleAttrs = roleResult.getAttributes();
            Attribute roleAttr = roleAttrs.get(this.roleMemberRDN);
            NamingEnumeration<?> valueEnum = roleAttr.getAll();
            while (valueEnum != null && valueEnum.hasMore()) {
                HashSet roles;
                String value = (String)valueEnum.next();
                if (!value.endsWith("," + this.userBase)) {
                    log.debug("found unrecognized DN: " + value, new Object[0]);
                    continue;
                }
                String name = value.substring(0, value.length() - this.userBase.length() - 1);
                name = name.split("=")[1];
                if (users.containsKey(name)) {
                    roles = (HashSet)users.get(name);
                    roles.add(roleResultValue);
                    continue;
                }
                roles = new HashSet();
                roles.add(roleResultValue);
                users.put(name, roles);
            }
        }
        return users;
    }

    private NamingEnumeration search(String base, String filter, String[] returnAttrs) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(returnAttrs);
        DirContext dirContext = this.context();
        return dirContext.search(base, filter, constraints);
    }
}

