/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.pam;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.rundeck.jaas.AbstractSharedLoginModule;

public abstract class AbstractPamLoginModule
extends AbstractSharedLoginModule {
    public static final Logger logger = Logger.getLogger(AbstractPamLoginModule.class.getName());
    private String serviceName;
    private UnixUser unixUser;
    private boolean useUnixGroups;
    private List<String> supplementalRoles;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map shared, Map options) {
        super.initialize(subject, callbackHandler, shared, options);
        Object service = options.get("service");
        if (null == service) {
            throw new IllegalStateException("service is required");
        }
        this.serviceName = service.toString();
        Object useUnixGroups1 = options.get("useUnixGroups");
        this.useUnixGroups = null != useUnixGroups1 ? Boolean.parseBoolean(useUnixGroups1.toString()) : false;
        Object supplementalRoles1 = options.get("supplementalRoles");
        if (null != supplementalRoles1) {
            this.supplementalRoles = new ArrayList<String>();
            this.supplementalRoles.addAll(Arrays.asList(supplementalRoles1.toString().split(", *")));
        }
    }

    @Override
    protected boolean authenticate(String name, char[] password) throws LoginException {
        try {
            if (name == null || password == null) {
                this.debug("user or pass is null");
                return false;
            }
            this.debug("PAM authentication trying (" + this.serviceName + ") for: " + name);
            UnixUser authenticate = new PAM(this.serviceName).authenticate(name, new String(password));
            this.debug("PAM authentication succeeded for: " + name);
            this.unixUser = authenticate;
            return true;
        }
        catch (PAMException e) {
            this.debug(e.getMessage());
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    protected void debug(String message) {
        logger.log(Level.INFO, message);
    }

    @Override
    protected List<Principal> createRolePrincipals() {
        return this.createRolePrincipals(this.unixUser);
    }

    @Override
    protected Principal createUserPrincipal() {
        return this.createUserPrincipal(this.unixUser);
    }

    protected abstract Principal createUserPrincipal(UnixUser var1);

    protected abstract Principal createRolePrincipal(String var1);

    protected List<Principal> createRolePrincipals(UnixUser username) {
        Principal rolePrincipal;
        ArrayList<Principal> principals = new ArrayList<Principal>();
        if (null != this.supplementalRoles) {
            for (String supplementalRole : this.supplementalRoles) {
                rolePrincipal = this.createRolePrincipal(supplementalRole);
                if (null == rolePrincipal) continue;
                principals.add(rolePrincipal);
            }
        }
        if (this.useUnixGroups) {
            for (String s : username.getGroups()) {
                rolePrincipal = this.createRolePrincipal(s);
                if (null == rolePrincipal) continue;
                principals.add(rolePrincipal);
            }
        }
        return principals;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.unixUser = null;
        }
        return super.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        this.unixUser = null;
        return super.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        this.unixUser = null;
        return super.logout();
    }

    public boolean isUseUnixGroups() {
        return this.useUnixGroups;
    }
}

