@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  launcher startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and LAUNCHER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\rundeck-launcher-2.11.4.jar;%APP_HOME%\lib\rundeck-jetty-server-2.11.4.jar;%APP_HOME%\lib\commons-cli-1.0.jar;%APP_HOME%\lib\log4j-1.2.16.jar;%APP_HOME%\lib\jetty-all-9.0.7.v20131107.jar;%APP_HOME%\lib\jetty-jaas-9.0.7.v20131107.jar;%APP_HOME%\lib\libpam4j-1.5.jar;%APP_HOME%\lib\not-yet-commons-ssl-0.3.17.jar;%APP_HOME%\lib\commons-logging-1.0.jar;%APP_HOME%\lib\commons-lang-1.0.jar;%APP_HOME%\lib\javax.servlet-3.0.0.v201112011016.jar;%APP_HOME%\lib\jetty-security-9.0.7.v20131107.jar;%APP_HOME%\lib\junit-3.7.jar;%APP_HOME%\lib\jetty-server-9.0.7.v20131107.jar;%APP_HOME%\lib\jetty-http-9.0.7.v20131107.jar;%APP_HOME%\lib\jetty-io-9.0.7.v20131107.jar;%APP_HOME%\lib\jetty-util-9.0.7.v20131107.jar

@rem Execute launcher
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %LAUNCHER_OPTS%  -classpath "%CLASSPATH%" com.dtolabs.rundeck.ExpandRunServer %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable LAUNCHER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%LAUNCHER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
