/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    static final Logger LOG = Log.getLogger(ByteArrayEndPoint.class);
    public static final InetSocketAddress NOIP = new InetSocketAddress(0);
    protected ByteBuffer _in;
    protected ByteBuffer _out;
    protected boolean _ishut;
    protected boolean _oshut;
    protected boolean _closed;
    protected boolean _growOutput;

    public ByteArrayEndPoint() {
        this(null, 0L, null, null);
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer((byte[])input) : null, BufferUtil.allocate((int)outputSize));
    }

    public ByteArrayEndPoint(String input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer((String)input) : null, BufferUtil.allocate((int)outputSize));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long idleTimeoutMs) {
        this(scheduler, idleTimeoutMs, null, null);
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, byte[] input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer((byte[])input) : null, BufferUtil.allocate((int)outputSize));
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, String input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer((String)input) : null, BufferUtil.allocate((int)outputSize));
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, ByteBuffer input, ByteBuffer output) {
        super(timer, NOIP, NOIP);
        this._in = input == null ? BufferUtil.EMPTY_BUFFER : input;
        this._out = output == null ? BufferUtil.allocate((int)1024) : output;
        this.setIdleTimeout(idleTimeoutMs);
    }

    @Override
    protected void onIncompleteFlush() {
    }

    @Override
    protected boolean needsFill() throws IOException {
        if (this._closed) {
            throw new ClosedChannelException();
        }
        return this._in == null || BufferUtil.hasContent((ByteBuffer)this._in);
    }

    public ByteBuffer getIn() {
        return this._in;
    }

    public void setInputEOF() {
        this._in = null;
    }

    public void setInput(ByteBuffer in) {
        this._in = in;
        if (in == null || BufferUtil.hasContent((ByteBuffer)in)) {
            this.getFillInterest().fillable();
        }
    }

    public void setInput(String s) {
        this.setInput(BufferUtil.toBuffer((String)s, (Charset)StandardCharsets.UTF_8));
    }

    public void setInput(String s, Charset charset) {
        this.setInput(BufferUtil.toBuffer((String)s, (Charset)charset));
    }

    public ByteBuffer getOutput() {
        return this._out;
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    public String getOutputString(Charset charset) {
        return BufferUtil.toString((ByteBuffer)this._out, (Charset)charset);
    }

    public ByteBuffer takeOutput() {
        ByteBuffer b = this._out;
        this._out = BufferUtil.allocate((int)b.capacity());
        this.getWriteFlusher().completeWrite();
        return b;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    public String takeOutputString(Charset charset) {
        ByteBuffer buffer = this.takeOutput();
        return BufferUtil.toString((ByteBuffer)buffer, (Charset)charset);
    }

    public void setOutput(ByteBuffer out) {
        this._out = out;
        this.getWriteFlusher().completeWrite();
    }

    @Override
    public boolean isOpen() {
        return !this._closed;
    }

    @Override
    public boolean isInputShutdown() {
        return this._ishut || this._closed;
    }

    @Override
    public boolean isOutputShutdown() {
        return this._oshut || this._closed;
    }

    private void shutdownInput() {
        this._ishut = true;
        if (this._oshut) {
            this.close();
        }
    }

    @Override
    public void shutdownOutput() {
        this._oshut = true;
        if (this._ishut) {
            this.close();
        }
    }

    @Override
    public void close() {
        this._closed = true;
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        if (this._closed) {
            throw new EofException("CLOSED");
        }
        if (this._in == null) {
            this.shutdownInput();
        }
        if (this._ishut) {
            return -1;
        }
        int filled = BufferUtil.flipPutFlip((ByteBuffer)this._in, (ByteBuffer)buffer);
        if (filled > 0) {
            this.notIdle();
        }
        return filled;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._oshut) {
            throw new IOException("OSHUT");
        }
        boolean flushed = true;
        boolean idle = true;
        for (ByteBuffer b : buffers) {
            if (!BufferUtil.hasContent((ByteBuffer)b)) continue;
            if (this._growOutput && b.remaining() > BufferUtil.space((ByteBuffer)this._out)) {
                BufferUtil.compact((ByteBuffer)this._out);
                if (b.remaining() > BufferUtil.space((ByteBuffer)this._out)) {
                    ByteBuffer n = BufferUtil.allocate((int)(this._out.capacity() + b.remaining() * 2));
                    BufferUtil.flipPutFlip((ByteBuffer)this._out, (ByteBuffer)n);
                    this._out = n;
                }
            }
            if (BufferUtil.flipPutFlip((ByteBuffer)b, (ByteBuffer)this._out) > 0) {
                idle = false;
            }
            if (!BufferUtil.hasContent((ByteBuffer)b)) continue;
            flushed = false;
            break;
        }
        if (!idle) {
            this.notIdle();
        }
        return flushed;
    }

    public void reset() {
        this.getFillInterest().onClose();
        this.getWriteFlusher().onClose();
        this._ishut = false;
        this._oshut = false;
        this._closed = false;
        this._in = null;
        BufferUtil.clear((ByteBuffer)this._out);
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean growOutput) {
        this._growOutput = growOutput;
    }
}

