/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    public static final TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final DateCache __dateCache = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final String __COOKIE_DELIM = "\",;\\ \t";
    public static final String __separators = ", \t";
    private static final String[] DAYS;
    private static final String[] MONTHS;
    private static final ThreadLocal<DateGenerator> __dateGenerator;
    private static final String[] __dateReceiveFmt;
    private static final ThreadLocal<DateParser> __dateParser;
    public static final String __01Jan1970;
    public static final ByteBuffer __01Jan1970_BUFFER;
    public static final String __01Jan1970_COOKIE;
    private final ArrayList<HttpField> _fields = new ArrayList(20);
    private static final Float __one;
    private static final Float __zero;
    private static final Trie<Float> __qualities;

    public static String formatDate(long date) {
        return __dateGenerator.get().formatDate(date);
    }

    public static void formatCookieDate(StringBuilder buf, long date) {
        __dateGenerator.get().formatCookieDate(buf, date);
    }

    public static String formatCookieDate(long date) {
        StringBuilder buf = new StringBuilder(28);
        HttpFields.formatCookieDate(buf, date);
        return buf.toString();
    }

    public static long parseDate(String date) {
        return __dateParser.get().parse(date);
    }

    public Collection<String> getFieldNamesCollection() {
        HashSet<String> list = new HashSet<String>(this._fields.size());
        for (HttpField f : this._fields) {
            if (f == null) continue;
            list.add(f.getName());
        }
        return list;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public int size() {
        return this._fields.size();
    }

    public HttpField getField(int i) {
        return this._fields.get(i);
    }

    @Override
    public Iterator<HttpField> iterator() {
        return this._fields.iterator();
    }

    public HttpField getField(HttpHeader header) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    public HttpField getField(String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public boolean contains(HttpHeader header, String value) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != header || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name, String value) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name) || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getStringField(HttpHeader header) {
        return this.getStringField(header.asString());
    }

    public String get(HttpHeader header) {
        return this.getStringField(header.asString());
    }

    public String get(String header) {
        return this.getStringField(header);
    }

    public String getStringField(String name) {
        HttpField field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public Collection<String> getValuesCollection(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this._fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            list.add(f.getValue());
        }
        return list;
    }

    public Enumeration<String> getValues(final String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            final HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name) || f.getValue() == null) continue;
            final int first = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = f;
                    this.i = first + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._fields.size()) {
                            this.field = (HttpField)HttpFields.this._fields.get(this.i++);
                            if (!this.field.getName().equalsIgnoreCase(name) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() throws NoSuchElementException {
                    if (this.hasMoreElements()) {
                        String value = this.field.getValue();
                        this.field = null;
                        return value;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List empty = Collections.emptyList();
        return Collections.enumeration(empty);
    }

    public Enumeration<String> getValues(String name, final String separators) {
        final Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    if (value == null) continue;
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public void put(HttpField field) {
        boolean put = false;
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (!f.isSame(field)) continue;
            if (put) {
                this._fields.remove(i);
                continue;
            }
            this._fields.set(i, field);
            put = true;
        }
        if (!put) {
            this._fields.add(field);
        }
    }

    public void put(String name, String value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.put(new HttpField(name, value));
        }
    }

    public void put(HttpHeader header, HttpHeaderValue value) {
        this.put(header, value.toString());
    }

    public void put(HttpHeader header, String value) {
        if (value == null) {
            this.remove(header);
        } else {
            this.put(new HttpField(header, value));
        }
    }

    public void put(String name, List<String> list) {
        this.remove(name);
        for (String v : list) {
            if (v == null) continue;
            this.add(name, v);
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        HttpField field = new HttpField(name, value);
        this._fields.add(field);
    }

    public void add(HttpHeader header, HttpHeaderValue value) throws IllegalArgumentException {
        this.add(header, value.toString());
    }

    public void add(HttpHeader header, String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, value);
        this._fields.add(field);
    }

    public void remove(HttpHeader name) {
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != name) continue;
            this._fields.remove(i);
        }
    }

    public void remove(String name) {
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            this._fields.remove(i);
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getDateField(String name) {
        HttpField field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = __dateParser.get().parse(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(HttpHeader name, long value) {
        String v = Long.toString(value);
        this.put(name, v);
    }

    public void putLongField(String name, long value) {
        String v = Long.toString(value);
        this.put(name, v);
    }

    public void putDateField(HttpHeader name, long date) {
        String d = HttpFields.formatDate(date);
        this.put(name, d);
    }

    public void putDateField(String name, long date) {
        String d = HttpFields.formatDate(date);
        this.put(name, d);
    }

    public void addDateField(String name, long date) {
        String d = HttpFields.formatDate(date);
        this.add(name, d);
    }

    public void addSetCookie(HttpCookie cookie) {
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getComment(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String name, String value, String domain, String path, long maxAge, String comment, boolean isSecure, boolean isHttpOnly, int version) {
        boolean quote_path;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder(128);
        boolean quote_name = HttpFields.isQuoteNeededForCookie(name);
        HttpFields.quoteOnlyOrAppend(buf, name, quote_name);
        buf.append('=');
        String name_equals = buf.toString();
        boolean quote_value = HttpFields.isQuoteNeededForCookie(value);
        HttpFields.quoteOnlyOrAppend(buf, value, quote_value);
        boolean has_domain = domain != null && domain.length() > 0;
        boolean quote_domain = has_domain && HttpFields.isQuoteNeededForCookie(domain);
        boolean has_path = path != null && path.length() > 0;
        boolean bl = quote_path = has_path && HttpFields.isQuoteNeededForCookie(path);
        if (version == 0 && (comment != null || quote_name || quote_value || quote_domain || quote_path || QuotedStringTokenizer.isQuoted((String)name) || QuotedStringTokenizer.isQuoted((String)value) || QuotedStringTokenizer.isQuoted((String)path) || QuotedStringTokenizer.isQuoted((String)domain))) {
            version = 1;
        }
        if (version == 1) {
            buf.append(";Version=1");
        } else if (version > 1) {
            buf.append(";Version=").append(version);
        }
        if (has_path) {
            buf.append(";Path=");
            HttpFields.quoteOnlyOrAppend(buf, path, quote_path);
        }
        if (has_domain) {
            buf.append(";Domain=");
            HttpFields.quoteOnlyOrAppend(buf, domain, quote_domain);
        }
        if (maxAge >= 0L) {
            buf.append(";Expires=");
            if (maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                HttpFields.formatCookieDate(buf, System.currentTimeMillis() + 1000L * maxAge);
            }
            if (version >= 1) {
                buf.append(";Max-Age=");
                buf.append(maxAge);
            }
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        if (comment != null) {
            buf.append(";Comment=");
            HttpFields.quoteOnlyOrAppend(buf, comment, HttpFields.isQuoteNeededForCookie(comment));
        }
        Iterator<HttpField> i = this._fields.iterator();
        while (i.hasNext()) {
            String val;
            HttpField field = i.next();
            if (field.getHeader() != HttpHeader.SET_COOKIE || (val = field.getValue()) == null || !val.startsWith(name_equals) || (has_domain || val.contains("Domain")) && (!has_domain || !val.contains(domain)) || (has_path || val.contains("Path")) && (!has_path || !val.contains(path))) continue;
            i.remove();
        }
        this.add(HttpHeader.SET_COOKIE.toString(), buf.toString());
        this.put(HttpHeader.EXPIRES.toString(), __01Jan1970);
    }

    public void putTo(ByteBuffer bufferInFillMode) {
        for (HttpField field : this._fields) {
            if (field == null) continue;
            field.putTo(bufferInFillMode);
        }
        BufferUtil.putCRLF((ByteBuffer)bufferInFillMode);
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this._fields) {
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return e.toString();
        }
    }

    public void clear() {
        this._fields.clear();
    }

    public void add(HttpField field) {
        this._fields.add(field);
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Map<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Float q;
        Float q2;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (q2 = (Float)__qualities.get(value, ++qe, value.length() - qe)) != null) {
            return q2;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        HttpFields.valueParameters(value, params);
        String qs = (String)params.get("q");
        if (qs == null) {
            qs = "*";
        }
        if ((q = (Float)__qualities.get(qs)) == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List<String> qualityList(Enumeration<String> e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.emptyList();
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, (Object)v);
            qual = LazyList.add(qual, (Object)q);
        }
        List vl = LazyList.getList(list, (boolean)false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, (boolean)false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                String tmp = (String)vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    public static boolean isQuoteNeededForCookie(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    private static void quoteOnlyOrAppend(StringBuilder buf, String s, boolean quote) {
        if (quote) {
            QuotedStringTokenizer.quoteOnly((Appendable)buf, (String)s);
        } else {
            buf.append(s);
        }
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __dateGenerator = new ThreadLocal<DateGenerator>(){

            @Override
            protected DateGenerator initialValue() {
                return new DateGenerator();
            }
        };
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
        __dateParser = new ThreadLocal<DateParser>(){

            @Override
            protected DateParser initialValue() {
                return new DateParser();
            }
        };
        __01Jan1970 = HttpFields.formatDate(0L);
        __01Jan1970_BUFFER = BufferUtil.toBuffer((String)__01Jan1970);
        __01Jan1970_COOKIE = HttpFields.formatCookieDate(0L).trim();
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new ArrayTernaryTrie();
        __qualities.put("*", (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    private static class DateParser {
        final SimpleDateFormat[] _dateReceive = new SimpleDateFormat[HttpFields.access$200().length];

        private DateParser() {
        }

        long parse(String dateVal) {
            for (int i = 0; i < this._dateReceive.length; ++i) {
                if (this._dateReceive[i] == null) {
                    this._dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
                    this._dateReceive[i].setTimeZone(__GMT);
                }
                try {
                    Date date = (Date)this._dateReceive[i].parseObject(dateVal);
                    return date.getTime();
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (dateVal.endsWith(" GMT")) {
                String val = dateVal.substring(0, dateVal.length() - 4);
                for (SimpleDateFormat element : this._dateReceive) {
                    try {
                        Date date = (Date)element.parseObject(val);
                        return date.getTime();
                    }
                    catch (Exception e) {
                    }
                }
            }
            return -1L;
        }
    }

    public static class DateGenerator {
        private final StringBuilder buf = new StringBuilder(32);
        private final GregorianCalendar gc = new GregorianCalendar(__GMT);

        public String formatDate(long date) {
            this.buf.setLength(0);
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            int century = year / 100;
            year %= 100;
            int hours = this.gc.get(11);
            int minutes = this.gc.get(12);
            int seconds = this.gc.get(13);
            this.buf.append(DAYS[day_of_week]);
            this.buf.append(',');
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)day_of_month);
            this.buf.append(' ');
            this.buf.append(MONTHS[month]);
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)century);
            StringUtil.append2digits((StringBuilder)this.buf, (int)year);
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)hours);
            this.buf.append(':');
            StringUtil.append2digits((StringBuilder)this.buf, (int)minutes);
            this.buf.append(':');
            StringUtil.append2digits((StringBuilder)this.buf, (int)seconds);
            this.buf.append(" GMT");
            return this.buf.toString();
        }

        public void formatCookieDate(StringBuilder buf, long date) {
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            year %= 10000;
            int epoch = (int)(date / 1000L % 86400L);
            int seconds = epoch % 60;
            int minutes = (epoch /= 60) % 60;
            int hours = epoch / 60;
            buf.append(DAYS[day_of_week]);
            buf.append(',');
            buf.append(' ');
            StringUtil.append2digits((StringBuilder)buf, (int)day_of_month);
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits((StringBuilder)buf, (int)(year / 100));
            StringUtil.append2digits((StringBuilder)buf, (int)(year % 100));
            buf.append(' ');
            StringUtil.append2digits((StringBuilder)buf, (int)hours);
            buf.append(':');
            StringUtil.append2digits((StringBuilder)buf, (int)minutes);
            buf.append(':');
            StringUtil.append2digits((StringBuilder)buf, (int)seconds);
            buf.append(" GMT");
        }
    }
}

