/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderUtil {
    private ArrayList<File> libdirs = new ArrayList();
    private ArrayList<File> jars = new ArrayList();
    private static boolean isDebug = Boolean.getBoolean("rundeck.classloader.debug");

    public ClassLoaderUtil(File libdir) {
        this.libdirs.add(libdir);
        ClassLoaderUtil.DEBUG("lib dirs: " + this.libdirs);
    }

    public void addJarFile(File jarfile) {
        this.jars.add(jarfile);
    }

    public void addLibDir(File libdir) {
        this.libdirs.add(libdir);
    }

    public static Method findMain(Class cls) throws NoSuchMethodException {
        return cls.getDeclaredMethod("main", String[].class);
    }

    public ClassLoader getClassLoader(ClassLoader parent) throws MalformedURLException {
        return ClassLoaderUtil.getClassLoader(parent, this.libdirs, this.jars);
    }

    private static ClassLoader getClassLoader(ClassLoader parent, List<File> dirs, List<File> jars) throws MalformedURLException {
        ArrayList<URL> jarUrlList = new ArrayList<URL>();
        ClassLoaderUtil.addDirJars(dirs, jarUrlList);
        ClassLoaderUtil.addJars(jars, jarUrlList);
        ClassLoaderUtil.DEBUG("jar list: " + jarUrlList);
        return URLClassLoader.newInstance(jarUrlList.toArray(new URL[jarUrlList.size()]), parent);
    }

    private static void addJars(List<File> jars, List<URL> jarUrlList) throws MalformedURLException {
        for (File jar : jars) {
            jarUrlList.add(jar.toURI().toURL());
        }
    }

    private static void addDirJars(List<File> dirs, List<URL> jarUrlList) throws MalformedURLException {
        for (File jarDir : dirs) {
            List<URL> jarUrls = ClassLoaderUtil.listJarUrls(jarDir);
            jarUrlList.addAll(jarUrls);
        }
    }

    private static List<URL> listJarUrls(File jarDir) throws MalformedURLException {
        String[] dirList;
        if (!jarDir.isDirectory()) {
            throw new IllegalArgumentException("path: " + jarDir.getAbsolutePath() + " is not a directory");
        }
        ArrayList<URL> jarUrlList = new ArrayList<URL>();
        for (String dirEntry : dirList = jarDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            ClassLoaderUtil.DEBUG("listJarUrls(), adding jar: " + dirEntry);
            URL jarUrl = new File(jarDir, dirEntry).toURI().toURL();
            jarUrlList.add(jarUrl);
        }
        return jarUrlList;
    }

    private static void DEBUG(String msg) {
        if (isDebug) {
            System.err.println("ClassLoaderUtil: " + msg);
        }
    }
}

