/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.server.projects;

import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RundeckProjectConfig
implements IRundeckProjectConfig {
    private String name;
    private Date lastModifiedTime;
    private IPropertyLookup lookup;
    private IPropertyLookup projectLookup;

    public RundeckProjectConfig(String name, IPropertyLookup lookup, IPropertyLookup projectLookup, Date lastModifiedTime) {
        this.name = name;
        this.setLookup(lookup);
        this.setProjectLookup(projectLookup);
        this.setLastModifiedTime(lastModifiedTime);
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String property) {
        return this.getLookup().getProperty(property);
    }

    public boolean hasProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != this.getLookup()) {
            for (Object key : this.getLookup().getPropertiesMap().keySet()) {
                result.put(key.toString(), this.getLookup().getProperty(key.toString()));
            }
        }
        return result;
    }

    public Map<String, String> getProjectProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != this.getProjectLookup()) {
            for (Object key : this.getProjectLookup().getPropertiesMap().keySet()) {
                result.put(key.toString(), this.getProjectLookup().getProperty(key.toString()));
            }
        }
        return result;
    }

    public Date getConfigLastModifiedTime() {
        return this.getLastModifiedTime();
    }

    public String toString() {
        return "RundeckProjectConfig{name='" + this.name + '\'' + ", lastModifiedTime=" + this.getLastModifiedTime() + '}';
    }

    public IPropertyLookup getLookup() {
        return this.lookup;
    }

    public void setLookup(IPropertyLookup lookup) {
        this.lookup = lookup;
    }

    public IPropertyLookup getProjectLookup() {
        return this.projectLookup;
    }

    public void setProjectLookup(IPropertyLookup projectLookup) {
        this.projectLookup = projectLookup;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }
}

