/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.grails.profiler;

import com.linkedin.grails.profiler.ClassUtil;
import com.linkedin.grails.profiler.ProfilerAppender;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAppender
implements ProfilerAppender {
    public static final String LOGGER_NAME = "com.linkedin.grails.ProfilerPlugin";
    private Map<String, Long> startTimes = new HashMap();
    private int indentLevel;
    private String padding = "  ";

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public void logEntry(String label, Class<?> clazz, String name, long entryTime) {
        clazz = ClassUtil.getRealClass(clazz);
        Logger log = LoggerFactory.getLogger((String)LOGGER_NAME);
        String identity = this.getIdentity(label, clazz, name);
        this.startTimes.put(identity, entryTime);
        log.info(this.getIndent() + "Entering " + identity);
        ++this.indentLevel;
    }

    public void logExit(String label, Class<?> clazz, String name, long exitTime) {
        clazz = ClassUtil.getRealClass(clazz);
        Logger log = LoggerFactory.getLogger((String)LOGGER_NAME);
        --this.indentLevel;
        String identity = this.getIdentity(label, clazz, name);
        long startTime = (Long)this.startTimes.get(identity);
        long totalTime = exitTime - startTime;
        log.info(this.getIndent() + "Exiting " + identity + "   (Time: " + totalTime + ")");
    }

    private String getIndent() {
        StringBuilder buffer = new StringBuilder(this.indentLevel * this.padding.length());
        for (int i = 0; i < this.indentLevel; ++i) {
            buffer.append(this.padding);
        }
        return buffer.toString();
    }

    private String getIdentity(String label, Class<?> clazz, String name) {
        return "[" + label + "] " + clazz.getName() + ":" + name;
    }
}

