/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugin.platform.events;

import grails.events.EventException;
import groovy.lang.Closure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EventReply
implements Serializable,
Future<Object> {
    private static final long serialVersionUID = 1L;
    private Future<?> futureReply;
    private List<Object> values;
    private Object value;
    private int receivers;
    private boolean futureReplyLoaded = false;
    private Closure onError;

    public void setOnError(Closure onError) {
        this.onError = onError;
    }

    public Closure getOnError() {
        return this.onError;
    }

    public EventReply(Object val, int receivers) {
        this.receivers = receivers;
        this.initValues(val);
    }

    protected void initValues(Object val) {
        this.values = new ArrayList();
        if (this.receivers > 1 && val instanceof Collection) {
            this.values.addAll((Collection)val);
            this.value = this.values.get(0);
        } else if (this.receivers != 0 || val != null) {
            this.value = val;
            this.values.add(this.value);
        }
        this.futureReplyLoaded = true;
    }

    public EventReply(Future<?> future, int receivers) {
        this.receivers = receivers;
        this.futureReply = future;
    }

    protected void addValue(Object v) {
        this.values.add(v);
    }

    public List<Object> getValues() throws Throwable {
        if (!this.futureReplyLoaded) {
            this.get();
        }
        this.throwError();
        return this.values;
    }

    public Object getValue() throws Throwable {
        if (!this.futureReplyLoaded) {
            this.get();
        }
        this.throwError();
        return this.value;
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean cancel(boolean b) {
        return this.futureReply == null || this.futureReply.cancel(b);
    }

    @Override
    public boolean isCancelled() {
        return this.futureReply != null && this.futureReply.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.futureReply == null || this.futureReply.isDone();
    }

    public boolean isSuccess() {
        return this.isDone() && !this.hasErrors();
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> ex = new ArrayList<Throwable>();
        if (this.values != null) {
            for (Object v : this.values) {
                if (v == null || !Throwable.class.isAssignableFrom(v.getClass())) continue;
                ex.add((Throwable)v);
            }
        }
        return ex;
    }

    public boolean hasErrors() {
        for (Object v : this.values) {
            if (v == null || !Throwable.class.isAssignableFrom(v.getClass())) continue;
            return true;
        }
        return false;
    }

    public void throwError() throws Throwable {
        if (this.hasErrors()) {
            if (this.onError != null) {
                this.onError.call((Object)this);
            } else {
                throw new EventException((Throwable)this.getErrors().get(0));
            }
        }
    }

    public int size() throws Throwable {
        this.get();
        this.throwError();
        return this.receivers;
    }

    protected void setReceivers(int receivers) {
        this.receivers = receivers;
    }

    public EventReply waitFor() throws Throwable {
        this.get();
        this.throwError();
        return this;
    }

    public EventReply waitFor(long l) throws Throwable {
        this.get(l, TimeUnit.MILLISECONDS);
        this.throwError();
        return this;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        Object val;
        Object object = val = this.futureReply == null ? this.value : this.futureReply.get();
        if (!this.futureReplyLoaded) {
            this.initValues(val);
        }
        return val;
    }

    @Override
    public Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object val;
        Object object = val = this.futureReply == null ? this.value : this.futureReply.get(l, timeUnit);
        if (!this.futureReplyLoaded) {
            this.initValues(val);
        }
        return val;
    }
}

