/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck;

import com.dtolabs.rundeck.ClassLoaderUtil;
import com.dtolabs.rundeck.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ExpandRunServer {
    private static final String CONFIG_DEFAULTS_PROPERTIES = "config-defaults.properties";
    private static final String SYS_PROP_RUNDECK_LAUNCHER_DEBUG = "rundeck.launcher.debug";
    private static final String SYS_PROP_RUNDECK_LAUNCHER_REWRITE = "rundeck.launcher.rewrite";
    private static final String SYS_PROP_RUNDECK_JAASLOGIN = "rundeck.jaaslogin";
    private static final String RUN_SERVER_CLASS = "com.dtolabs.rundeck.RunServer";
    private static final String PROP_LOGINMODULE_NAME = "loginmodule.name";
    private static final String SERVER_DATASTORE_PATH = "server.datastore.path";
    private static final String RUNDECK_SERVER_CONFIG_DIR = "rundeck.server.configDir";
    static final String[] configProperties = new String[]{"server.http.port", "server.https.port", "server.hostname", "server.web.context", "rdeck.base", "server.datastore.path", "default.user.name", "default.user.password", "loginmodule.name", "loginmodule.conf.name", "rundeck.config.name"};
    private static final String LINESEP = System.getProperty("line.separator");
    public static final String FLAG_INSTALLONLY = "installonly";
    public static final String FLAG_SKIPINSTALL = "skipinstall";
    String basedir;
    File serverdir;
    File configDir;
    File datadir;
    File thisJar;
    String coreJarName;
    boolean debug = false;
    boolean rewrite = false;
    boolean useJaas = true;
    String versionString;
    private String runClassName;
    private String jettyLibsString;
    private String jettyLibPath;
    private static final String RUNDECK_START_CLASS = "Rundeck-Start-Class";
    private static final String RUNDECK_JETTY_LIBS = "Rundeck-Jetty-Libs";
    private static final String RUNDECK_JETTY_LIB_PATH = "Rundeck-Jetty-Lib-Path";
    private static final String RUNDECK_VERSION = "Rundeck-Version";
    private final Options options = new Options();
    private static final String PROPERTY_PATTERN = "\\$\\{([^\\}]+?)\\}";

    public static void main(String[] args) throws Exception {
        new ExpandRunServer().run(args);
    }

    public ExpandRunServer() {
        OptionBuilder.withLongOpt("basedir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The basedir");
        OptionBuilder.withArgName("PATH");
        Option baseDir = OptionBuilder.create('b');
        OptionBuilder.withLongOpt("serverdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The base directory for the server");
        OptionBuilder.withArgName("PATH");
        Option serverDir = OptionBuilder.create();
        OptionBuilder.withLongOpt("bindir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PATH");
        OptionBuilder.withDescription("The install directory for the tools used by users.");
        Option binDir = OptionBuilder.create('x');
        OptionBuilder.withLongOpt("sbindir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PATH");
        OptionBuilder.withDescription("The install directory for the tools used by administrators.");
        Option sbinDir = OptionBuilder.create('s');
        OptionBuilder.withLongOpt("configdir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PATH");
        OptionBuilder.withDescription("The location of the configuration.");
        Option configDir = OptionBuilder.create('c');
        OptionBuilder.withLongOpt("datadir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PATH");
        OptionBuilder.withDescription("The location of Rundeck's runtime data.");
        Option dataDir = OptionBuilder.create();
        OptionBuilder.withLongOpt("projectdir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PATH");
        OptionBuilder.withDescription("The location of Rundeck's project data.");
        Option projectDir = OptionBuilder.create('p');
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Display this message.");
        Option help = OptionBuilder.create('h');
        OptionBuilder.withDescription("Show debug information");
        Option debugFlag = OptionBuilder.create('d');
        OptionBuilder.withLongOpt(FLAG_SKIPINSTALL);
        OptionBuilder.withDescription("Skip the extraction of the utilities from the launcher.");
        Option skipInstall = OptionBuilder.create();
        OptionBuilder.withLongOpt(FLAG_INSTALLONLY);
        OptionBuilder.withDescription("Perform installation only and do not start the server.");
        Option installonly = OptionBuilder.create();
        this.options.addOption(baseDir);
        this.options.addOption(dataDir);
        this.options.addOption(serverDir);
        this.options.addOption(binDir);
        this.options.addOption(sbinDir);
        this.options.addOption(configDir);
        this.options.addOption(help);
        this.options.addOption(debugFlag);
        this.options.addOption(skipInstall);
        this.options.addOption(installonly);
        this.options.addOption(projectDir);
        this.debug = Boolean.getBoolean(SYS_PROP_RUNDECK_LAUNCHER_DEBUG);
        this.rewrite = Boolean.getBoolean(SYS_PROP_RUNDECK_LAUNCHER_REWRITE);
        this.useJaas = null == System.getProperty(SYS_PROP_RUNDECK_JAASLOGIN) || Boolean.getBoolean(SYS_PROP_RUNDECK_JAASLOGIN);
        this.runClassName = RUN_SERVER_CLASS;
        this.thisJar = ExpandRunServer.thisJarFile();
        Attributes mainAttributes = ExpandRunServer.getJarMainAttributes();
        if (null == mainAttributes) {
            throw new RuntimeException("Unable to load attributes");
        }
        this.versionString = mainAttributes.getValue(RUNDECK_VERSION);
        if (null == this.versionString) {
            throw new RuntimeException("Jar file attribute not found: Rundeck-Version");
        }
        this.DEBUG("Rundeck version: " + this.versionString);
        this.runClassName = mainAttributes.getValue(RUNDECK_START_CLASS);
        if (null == this.runClassName) {
            throw new RuntimeException("Jar file attribute not found: Rundeck-Start-Class");
        }
        this.jettyLibsString = mainAttributes.getValue(RUNDECK_JETTY_LIBS);
        if (null == this.jettyLibsString) {
            throw new RuntimeException("Jar file attribute not found: Rundeck-Jetty-Libs");
        }
        this.jettyLibPath = mainAttributes.getValue(RUNDECK_JETTY_LIB_PATH);
        if (null == this.jettyLibPath) {
            throw new RuntimeException("Jar file attribute not found: Rundeck-Jetty-Lib-Path");
        }
    }

    public void run(String[] args) throws Exception {
        CommandLine cl;
        GnuParser parser = new GnuParser();
        try {
            cl = parser.parse(this.options, args);
            if (cl.hasOption('h')) {
                this.printUsage();
                return;
            }
            if (cl.hasOption(FLAG_INSTALLONLY) && cl.hasOption(FLAG_SKIPINSTALL)) {
                this.ERR("--installonly and --skipinstall are mutually exclusive");
                this.printUsage();
                System.exit(1);
                return;
            }
        }
        catch (ParseException e) {
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
            System.exit(1);
            return;
        }
        this.debug = this.debug || cl.hasOption('d');
        this.DEBUG("Debugging is turned on.");
        this.basedir = cl.getOptionValue('b', new File(this.thisJar.getAbsolutePath()).getParentFile().getAbsolutePath());
        this.serverdir = new File(cl.getOptionValue("serverdir", this.basedir + "/server"));
        this.configDir = new File(cl.getOptionValue("c", this.serverdir + "/config"));
        this.datadir = new File(cl.getOptionValue("datadir", this.serverdir + "/data"));
        this.DEBUG("configDir is " + this.configDir.getAbsolutePath());
        File toolsdir = new File(this.basedir, "tools");
        File toolslibdir = new File(toolsdir, "lib");
        File bindir = new File(cl.getOptionValue('x', toolsdir.getAbsolutePath() + "/bin"));
        this.initArgs();
        this.coreJarName = "rundeck-core-" + this.versionString + ".jar";
        if (null != this.basedir) {
            System.setProperty("rdeck.base", ExpandRunServer.forwardSlashPath(this.basedir));
        }
        Properties defaults = this.loadDefaults(CONFIG_DEFAULTS_PROPERTIES);
        Properties configuration = this.createConfiguration(defaults);
        configuration.put("realm.properties.location", ExpandRunServer.forwardSlashPath(this.configDir.getAbsolutePath()) + "/realm.properties");
        this.DEBUG("Runtime configuration properties: " + configuration);
        if (!cl.hasOption(FLAG_SKIPINSTALL)) {
            File libdir = new File(this.serverdir, "lib");
            this.DEBUG("Extracting libs to: " + libdir.getAbsolutePath() + " ... ");
            this.deleteExistingJarsInDir(libdir, "^rundeck.*");
            this.extractLibs(libdir);
            this.extractJettyLibs(libdir);
            File expdir = new File(this.serverdir, "exp");
            this.DEBUG("Extracting webapp to: " + expdir.getAbsolutePath() + " ... ");
            this.deleteExistingJarsInDir(new File(expdir, "webapp/WEB-INF/lib"), "^rundeck.*");
            this.extractWar(expdir);
            this.DEBUG("Extracting bin scripts to: " + bindir.getAbsolutePath() + " ... ");
            this.extractBin(bindir, new File(this.serverdir, "exp/webapp/WEB-INF/lib/" + this.coreJarName));
            this.deleteExistingJarsInDir(toolslibdir, "^rundeck.*");
            this.copyToolLibs(toolslibdir, new File(this.serverdir, "exp/webapp/WEB-INF/lib/" + this.coreJarName));
            this.expandTemplates(configuration, this.serverdir, this.rewrite);
            this.setScriptFilesExecutable(new File(this.serverdir, "sbin"));
        } else {
            this.DEBUG("--skipinstall: Not extracting.");
        }
        if (cl.hasOption('p')) {
            System.setProperty("rdeck.projects", cl.getOptionValue('p'));
        }
        if (cl.hasOption(FLAG_INSTALLONLY)) {
            this.DEBUG("Done. --installonly: Not starting server.");
        } else {
            this.execute(cl.getArgs(), this.configDir, new File(this.basedir), this.serverdir, configuration);
        }
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java [JAVA_OPTIONS] -jar rundeck-launcher.jar ", "\nRun the rundeck server, installing the necessary components if they do not exist.\n", this.options, "\nhttp://rundeck.org\n", true);
    }

    private void extractLauncherContents(File targetdir, String prefix, String stripPrefix) throws IOException {
        if (!targetdir.exists() && !targetdir.mkdirs()) {
            this.ERR("Unable to create dir: " + targetdir);
        }
        ZipUtil.extractZip(this.thisJar.getAbsolutePath(), targetdir, prefix, stripPrefix);
    }

    private void setScriptFilesExecutable(File sbindir) {
        if (sbindir.exists()) {
            for (String s : sbindir.list()) {
                File script = new File(sbindir, s);
                if (!script.isFile() || script.setExecutable(true)) continue;
                this.ERR("Unable to set executable permissions for file: " + script.getAbsolutePath());
            }
        }
    }

    private void copyToolLibs(File toolslibdir, File coreJar) throws IOException {
        if (!toolslibdir.isDirectory() && !toolslibdir.mkdirs()) {
            this.ERR("Couldn't create bin dir: " + toolslibdir.getAbsolutePath());
            return;
        }
        JarFile zf = new JarFile(coreJar);
        String depslist = zf.getManifest().getMainAttributes().getValue("Rundeck-Tools-Dependencies");
        if (null == depslist) {
            throw new RuntimeException("Rundeck Core jar file manifest attribute \"Rundeck-Tools-Dependencies\" was not found: " + coreJar.getAbsolutePath());
        }
        String[] jars = depslist.split(" ");
        String jarpath = this.jettyLibPath;
        for (String jarName : jars) {
            ZipUtil.extractZip(this.thisJar.getAbsolutePath(), toolslibdir, jarpath + "/" + jarName, jarpath + "/");
            if (new File(toolslibdir, jarName).exists()) continue;
            this.ERR("Failed to extract dependent jar for tools into " + toolslibdir.getAbsolutePath() + ": " + jarName);
        }
        File destfile = new File(toolslibdir, this.coreJarName);
        if (!destfile.exists() && !destfile.createNewFile()) {
            this.ERR("Unable to create file: " + destfile.createNewFile());
        }
        ZipUtil.copyStream(new FileInputStream(coreJar), new FileOutputStream(destfile));
    }

    private void extractBin(File destDir, File coreJar) throws IOException {
        if (!destDir.isDirectory() && !destDir.mkdirs()) {
            this.ERR("Couldn't create bin dir: " + destDir.getAbsolutePath());
            return;
        }
        ZipUtil.extractZip(coreJar.getAbsolutePath(), destDir, "com/dtolabs/rundeck/core/cli/templates", "com/dtolabs/rundeck/core/cli/templates/");
        for (String s : destDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return !s.endsWith(".bat");
            }
        })) {
            File script = new File(destDir, s);
            if (script.setExecutable(true)) continue;
            this.ERR("Unable to set executable permissions for file: " + script.getAbsolutePath());
        }
    }

    private void expandTemplates(final Properties props, File directory, final boolean overwrite) throws IOException {
        if (overwrite) {
            this.DEBUG("Configuration overwrite is TRUE");
        }
        String tmplPrefix = "templates/";
        String tmplSuffix = ".template";
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new RuntimeException("Unable to create config dir: " + directory.getAbsolutePath());
        }
        final ZipUtil.renamer renamer2 = new ZipUtil.renamer(){

            @Override
            public String rename(String input) {
                if (input.endsWith(".template")) {
                    input = input.substring(0, input.length() - ".template".length());
                }
                if (input.startsWith("templates/")) {
                    input = input.substring("templates/".length());
                }
                return input;
            }
        };
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                boolean accept;
                String destName = renamer2.rename(name);
                File destFile = null != props.getProperty(destName + ".location") ? new File(props.getProperty(destName + ".location")) : new File(file, destName);
                boolean bl = accept = (overwrite || !destFile.isFile()) && name.startsWith("templates/") && name.endsWith(".template");
                if (accept) {
                    ExpandRunServer.this.DEBUG("Writing config file: " + destFile.getAbsolutePath());
                }
                return accept;
            }
        };
        ZipUtil.extractZip(this.thisJar.getAbsolutePath(), directory, filenameFilter, renamer2, (ZipUtil.streamCopier)new propertyExpander(props));
    }

    private static void expandTemplate(InputStream inputStream, OutputStream outputStream, Properties props) throws IOException {
        BufferedReader read = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter(outputStream));
        String line = read.readLine();
        while (null != line) {
            write.write(ExpandRunServer.expandProperties(props, line));
            write.write(LINESEP);
            line = read.readLine();
        }
        write.flush();
        write.close();
        read.close();
    }

    private Properties loadDefaults(String path) {
        Properties properties = new Properties();
        try {
            InputStream is = this.loadResourceInternal(CONFIG_DEFAULTS_PROPERTIES);
            if (null == is) {
                throw new RuntimeException("Unable to read config-defaults.properties from jar");
            }
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load config defaults: " + path + ": " + e.getMessage(), e);
        }
        return properties;
    }

    private Properties createConfiguration(Properties defaults) throws UnknownHostException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaults);
        String localhostname = this.getHostname();
        if (null != localhostname) {
            properties.put("server.hostname", localhostname);
        }
        properties.put("rdeck.base", ExpandRunServer.forwardSlashPath(this.basedir));
        properties.put(SERVER_DATASTORE_PATH, ExpandRunServer.forwardSlashPath(this.datadir.getAbsolutePath()) + "/grailsdb");
        properties.put("rundeck.log.dir", ExpandRunServer.forwardSlashPath(this.serverdir.getAbsolutePath()) + "/logs");
        properties.put("rundeck.launcher.jar.location", ExpandRunServer.forwardSlashPath(this.thisJar.getAbsolutePath()));
        properties.put(RUNDECK_SERVER_CONFIG_DIR, ExpandRunServer.forwardSlashPath(this.configDir.getAbsolutePath()));
        for (String configProperty : configProperties) {
            if (null == System.getProperty(configProperty)) continue;
            properties.put(configProperty, ExpandRunServer.forwardSlashPath(System.getProperty(configProperty)));
        }
        return properties;
    }

    public static String forwardSlashPath(String input) {
        if (System.getProperties().get("file.separator").equals("\\")) {
            return input.replaceAll("\\\\", "/");
        }
        return input;
    }

    private String getHostname() {
        String name = null;
        try {
            name = InetAddress.getLocalHost().getHostName();
            this.DEBUG("Determined hostname: " + name);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return name;
    }

    private void extractLibs(File libdir) throws IOException {
        ZipUtil.extractZip(this.thisJar.getAbsolutePath(), libdir, "lib/", "lib/");
    }

    private void extractJettyLibs(File libdir) throws IOException {
        String[] jarNames = this.jettyLibsString.split(" ");
        String jarpath = this.jettyLibPath;
        for (String jarName : jarNames) {
            ZipUtil.extractZip(this.thisJar.getAbsolutePath(), libdir, jarpath + "/" + jarName, jarpath + "/");
        }
    }

    private void extractWar(File expdir) throws IOException {
        ZipUtil.extractZip(this.thisJar.getAbsolutePath(), expdir, "pkgs", "pkgs/");
    }

    private void deleteExistingJarsInDir(File dir, final String fileMatch) {
        if (dir.isDirectory()) {
            File[] rundeckJars;
            for (File rundeckJar : rundeckJars = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.matches(fileMatch) && s.endsWith(".jar");
                }
            })) {
                this.DEBUG("Delete existing jar file: " + rundeckJar.getAbsolutePath());
                if (rundeckJar.delete()) continue;
                this.ERR("Unable to remove existing jar file: " + rundeckJar);
            }
        }
    }

    private void execute(String[] args, File configDir, File baseDir, File serverDir, Properties configuration) throws IOException {
        System.setProperty("server.http.port", configuration.getProperty("server.http.port"));
        System.setProperty(RUNDECK_SERVER_CONFIG_DIR, configDir.getAbsolutePath());
        System.setProperty("rundeck.server.serverDir", serverDir.getAbsolutePath());
        System.setProperty("rundeck.config.location", new File(configDir, configuration.getProperty("rundeck.config.name")).getAbsolutePath());
        if (this.useJaas) {
            System.setProperty("java.security.auth.login.config", new File(configDir, configuration.getProperty("loginmodule.conf.name")).getAbsolutePath());
            System.setProperty(PROP_LOGINMODULE_NAME, configuration.getProperty(PROP_LOGINMODULE_NAME));
        }
        ArrayList<Object> execargs = new ArrayList<Object>();
        execargs.add(baseDir.getAbsolutePath());
        if (args.length > 1) {
            execargs.addAll(Arrays.asList(Arrays.copyOfRange((Object[])args.clone(), 1, args.length)));
        }
        int result = 500;
        try {
            this.invokeMain(this.runClassName, execargs.toArray(new String[execargs.size()]), new File(this.serverdir, "lib"));
            result = 0;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.DEBUG("Finished, exit code: " + result);
        System.exit(result);
    }

    public void invokeMain(String CLASSNAME, String[] args, File libdir) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, MalformedURLException {
        ClassLoaderUtil clload = new ClassLoaderUtil(libdir);
        ClassLoader loader = clload.getClassLoader(ClassLoader.getSystemClassLoader());
        Class<?> cls = Class.forName(CLASSNAME, true, loader);
        Method mainMethod = ClassLoaderUtil.findMain(cls);
        Thread.currentThread().setContextClassLoader(loader);
        this.DEBUG("Start server with " + CLASSNAME + ".main(" + Arrays.toString(args) + ")");
        mainMethod.invoke(null, new Object[]{args});
    }

    private InputStream loadResourceInternal(String path) throws IOException {
        ZipFile jar = new ZipFile(this.thisJar);
        return jar.getInputStream(new ZipEntry(path));
    }

    private void initArgs() {
        if (null == this.basedir) {
            File base = new File(this.thisJar.getAbsolutePath()).getParentFile();
            this.basedir = base.getAbsolutePath();
            this.LOG("Rundeck basedir: " + this.basedir);
        }
    }

    private static Attributes getJarMainAttributes() {
        Attributes mainAttributes = null;
        try {
            File file = ExpandRunServer.thisJarFile();
            JarFile jarFile = new JarFile(file);
            mainAttributes = jarFile.getManifest().getMainAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mainAttributes;
    }

    private static File thisJarFile() {
        ProtectionDomain protectionDomain = ExpandRunServer.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        try {
            return new File(location.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void LOG(String s) {
        System.out.println(s);
    }

    private void ERR(String s) {
        System.err.println("ERROR: " + s);
    }

    private void DEBUG(String msg) {
        if (this.debug) {
            System.err.println("VERBOSE: " + msg);
        }
    }

    public static String expandProperties(Properties properties, String input) {
        Pattern pattern = Pattern.compile(PROPERTY_PATTERN);
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            if (null != properties.get(match)) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(properties.getProperty(match)));
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(0)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static class propertyExpander
    implements ZipUtil.streamCopier {
        Properties properties;

        public propertyExpander(Properties properties) {
            this.properties = properties;
        }

        @Override
        public void copyStream(InputStream in, OutputStream out) throws IOException {
            ExpandRunServer.expandTemplate(in, out, this.properties);
        }
    }
}

